<?php


/**
 * This class adds structure of 'file' table to 'pagedarts' DatabaseMap object.
 *
 *
 *
 * These statically-built map classes are used by Propel to do runtime db structure discovery.
 * For example, the createSelectSql() method checks the type of a given column used in an
 * ORDER BY clause to know whether it needs to apply SQL to make the ORDER BY case-insensitive
 * (i.e. if it's a text column type).
 *
 * @package    pagedarts.map
 */
class FileMapBuilder implements MapBuilder {

	/**
	 * The (dot-path) name of this class
	 */
	const CLASS_NAME = 'pagedarts.map.FileMapBuilder';

	/**
	 * The database map.
	 */
	private $dbMap;

	/**
	 * Tells us if this DatabaseMapBuilder is built so that we
	 * don't have to re-build it every time.
	 *
	 * @return     boolean true if this DatabaseMapBuilder is built, false otherwise.
	 */
	public function isBuilt()
	{
		return ($this->dbMap !== null);
	}

	/**
	 * Gets the databasemap this map builder built.
	 *
	 * @return     the databasemap
	 */
	public function getDatabaseMap()
	{
		return $this->dbMap;
	}

	/**
	 * The doBuild() method builds the DatabaseMap
	 *
	 * @return     void
	 * @throws     PropelException
	 */
	public function doBuild()
	{
		$this->dbMap = Propel::getDatabaseMap(FilePeer::DATABASE_NAME);

		$tMap = $this->dbMap->addTable(FilePeer::TABLE_NAME);
		$tMap->setPhpName('File');
		$tMap->setClassname('File');

		$tMap->setUseIdGenerator(true);

		$tMap->addPrimaryKey('FILE_ID', 'FileId', 'INTEGER', true, null);

		$tMap->addColumn('DATA', 'Data', 'BLOB', false, null);

		$tMap->addColumn('SLUG', 'Slug', 'VARCHAR', true, 128);

		$tMap->addColumn('MIME', 'Mime', 'VARCHAR', false, 128);

		$tMap->addForeignKey('ARTICLE_ID', 'ArticleId', 'INTEGER', 'article', 'ARTICLE_ID', false, null);

	} // doBuild()

} // FileMapBuilder
