<?php


/**
 * This class adds structure of 'auto' table to 'autokomis' DatabaseMap object.
 *
 *
 *
 * These statically-built map classes are used by Propel to do runtime db structure discovery.
 * For example, the createSelectSql() method checks the type of a given column used in an
 * ORDER BY clause to know whether it needs to apply SQL to make the ORDER BY case-insensitive
 * (i.e. if it's a text column type).
 *
 * @package    autokomis.map
 */
class AutoMapBuilder implements MapBuilder {

	/**
	 * The (dot-path) name of this class
	 */
	const CLASS_NAME = 'autokomis.map.AutoMapBuilder';

	/**
	 * The database map.
	 */
	private $dbMap;

	/**
	 * Tells us if this DatabaseMapBuilder is built so that we
	 * don't have to re-build it every time.
	 *
	 * @return     boolean true if this DatabaseMapBuilder is built, false otherwise.
	 */
	public function isBuilt()
	{
		return ($this->dbMap !== null);
	}

	/**
	 * Gets the databasemap this map builder built.
	 *
	 * @return     the databasemap
	 */
	public function getDatabaseMap()
	{
		return $this->dbMap;
	}

	/**
	 * The doBuild() method builds the DatabaseMap
	 *
	 * @return     void
	 * @throws     PropelException
	 */
	public function doBuild()
	{
		$this->dbMap = Propel::getDatabaseMap(AutoPeer::DATABASE_NAME);

		$tMap = $this->dbMap->addTable(AutoPeer::TABLE_NAME);
		$tMap->setPhpName('Auto');
		$tMap->setClassname('Auto');

		$tMap->setUseIdGenerator(true);

		$tMap->addPrimaryKey('AUTO_ID', 'AutoId', 'INTEGER', true, null);

		$tMap->addColumn('ROCZNIK', 'Rocznik', 'INTEGER', false, null);

		$tMap->addColumn('CENA', 'Cena', 'INTEGER', false, null);

		$tMap->addColumn('POJEMNOSC', 'Pojemnosc', 'FLOAT', false, null);

		$tMap->addColumn('PRZEBIEG', 'Przebieg', 'INTEGER', false, null);

		$tMap->addColumn('KOLOR', 'Kolor', 'VARCHAR', false, 255);

		$tMap->addColumn('TYP', 'Typ', 'VARCHAR', false, 20);

		$tMap->addColumn('PALIWO', 'Paliwo', 'VARCHAR', false, 20);

		$tMap->addColumn('UWAGI', 'Uwagi', 'LONGVARCHAR', false, null);

		$tMap->addColumn('SLUG', 'Slug', 'VARCHAR', true, 255);

		$tMap->addForeignKey('MODEL_ID', 'ModelId', 'INTEGER', 'model', 'MODEL_ID', true, null);

	} // doBuild()

} // AutoMapBuilder
