<?php

require 'autokomis/om/BaseModelPeer.php';


/**
 * Skeleton subclass for performing query and update operations on the 'model' table.
 *
 * 
 *
 * You should add additional methods to this class to meet the
 * application requirements.  This class will only be generated as
 * long as it does not already exist in the output directory.
 *
 * @package    autokomis
 */
class ModelPeer extends BaseModelPeer {


    public static function insertIfNotExists($dane)
    {
        $c = new Criteria();
        $c->add(self::SLUG, $dane['slug']);
        $tmp = parent::doSelectOne($c);
        if (!$tmp) {
            $tmp = new Model();
            $tmp->fromArray($dane, BasePeer::TYPE_FIELDNAME);
            $tmp->save();
        }
        return $tmp;
    }
    
    static public function doSelect($criteria = null, $con = null)
    {
        if (is_null($criteria)) {
            $criteria = new Criteria();
        } else {
            $criteria = clone $criteria;
        }
        $criteria->addAscendingOrderByColumn(ModelPeer::NAZWA);
        return parent::doSelect($criteria, $con);
    }

    static public function retrieveBySlug($slug)
    {
        $c = new Criteria();
        $c->add(self::SLUG, $slug);
        return parent::doSelectOne($c);
    }


} // ModelPeer
