<?php

require 'zengardencss/om/BaseProjekt.php';


/**
 * Skeleton subclass for representing a row from the 'projekt' table.
 *
 * 
 *
 * You should add additional methods to this class to meet the
 * application requirements.  This class will only be generated as
 * long as it does not already exist in the output directory.
 *
 * @package    zengardencss
 */
class Projekt extends BaseProjekt {

	/**
	 * Initializes internal state of Projekt object.
	 * @see        parent::__construct()
	 */
	public function __construct()
	{
		// Make sure that parent constructor is always invoked, since that
		// is where any default values for this object are set.
		parent::__construct();
	}
	
	public function __toString()
	{
	    return $this->getNazwa();
	}	
	
	public function czcionkiProjektu()
	{
	    $c = new Criteria();
	    $c->addAscendingOrderByColumn(CzcionkaPeer::NAZWA);
	    $tmp = $this->getProjektHasCzcionkasJoinCzcionka($c);
	    $wynik = array();
	    foreach ($tmp as $phcz) {
	        $wynik[] = $phcz->getCzcionka();
	    }
	    return $wynik;
	}
	
	public function ustalLiczbeCzcionek()
	{
        $c = new Criteria();
        $c->add(ProjektHasCzcionkaPeer::PROJEKT_ID, $this->getProjektId());
        $liczba_czcionek = ProjektHasCzcionkaPeer::doCount($c);
        $this->setLiczbaczcionek($liczba_czcionek);
        $this->save();
	}
	

} // Projekt
