<?php

error_reporting(E_ALL);
ini_set('display_errors', 1);

set_include_path(
    '../aplikacja/scripts' . PATH_SEPARATOR .
    '../aplikacja/scripts/include' . PATH_SEPARATOR .
    '../lib' . PATH_SEPARATOR .
    get_include_path()
);

require_once 'Doctrine/lib/Doctrine.php';
spl_autoload_register(array('Doctrine', 'autoload'));
$conn = Doctrine_Manager::connection('mysql://admin:password@localhost/aparatyfoto');
Doctrine::loadModels('./../lib', Doctrine::MODEL_LOADING_CONSERVATIVE);

$conn->exec('truncate table aparat');
$conn->exec('truncate table matryca');
$conn->exec('truncate table producent');

/*
Doctrine::dropDatabases();
Doctrine::createDatabases();
Doctrine::createTablesFromModels();
*/

$conn->setCollate('utf8_polish_ci');
$conn->setCharset('utf8');

require_once 'slugs.inc.php';
require_once 'vh-array.inc.php';

require_once '../lib/producent.php';
require_once '../lib/matryca.php';
require_once '../lib/aparat.php';

$plks = glob('dane/*.txt');
shuffle($plks);
foreach ($plks as $plk) {

    $dane = loadAssocArray($plk);

    $producent = Producent::insertIfNotExists($dane['producent']);
    $matryca   = Matryca::insertIfNotExists($dane['matryca']);
    
    $dane['producent_id'] = $producent['producent_id'];
    $dane['matryca_id'] = $matryca['matryca_id'];
    $dane['slug'] = string2slug($dane['model']);
    
    $aparat = new Aparat();
    $aparat->fromArray($dane);
    $aparat->save();
}