<?php

require 'noth/om/BaseImgPeer.php';


/**
 * Skeleton subclass for performing query and update operations on the 'img' table.
 *
 * 
 *
 * You should add additional methods to this class to meet the
 * application requirements.  This class will only be generated as
 * long as it does not already exist in the output directory.
 *
 * @package    noth
 */
class ImgPeer extends BaseImgPeer {

    static public function retrieveBySlug($slug)
    {
        $c = new Criteria();
        $c->add(self::SLUG, $slug);
        return parent::doSelectOne($c);
    }
    
    public static function insertIfNotExists($dane)
    {
        $c = new Criteria();
        $c->add(ImgPeer::SLUG, $dane['slug']);
        $tmp = ImgPeer::doSelectOne($c);
        if (!$tmp) {
            $tmp = new Img();
            $tmp->fromArray($dane, BasePeer::TYPE_FIELDNAME);
            $tmp->save();
        }
        return $tmp;
    }


} // ImgPeer
