set names utf8;
drop database if exists noth;
create database noth default character set utf8 collate utf8_polish_ci;
grant all on noth.* to admin@localhost identified by 'password';
flush privileges;
use noth;


# This is a fix for InnoDB in MySQL >= 4.1.x
# It "suspends judgement" for fkey relationships until are tables are set.
SET FOREIGN_KEY_CHECKS = 0;

#-----------------------------------------------------------------------------
#-- menu
#-----------------------------------------------------------------------------

DROP TABLE IF EXISTS `menu`;


CREATE TABLE `menu`
(
	`menu_id` INTEGER  NOT NULL AUTO_INCREMENT,
	`tytul` VARCHAR(255),
	`tresc` TEXT,
	`slug` VARCHAR(128),
	PRIMARY KEY (`menu_id`),
	UNIQUE KEY `menu_U_1` (`slug`(128))
)Type=InnoDB;

#-----------------------------------------------------------------------------
#-- pu
#-----------------------------------------------------------------------------

DROP TABLE IF EXISTS `pu`;


CREATE TABLE `pu`
(
	`pu_id` INTEGER  NOT NULL AUTO_INCREMENT,
	`tytul` VARCHAR(255),
	`tresc` TEXT,
	`slug` VARCHAR(128),
	PRIMARY KEY (`pu_id`),
	UNIQUE KEY `pu_U_1` (`slug`(128))
)Type=InnoDB;

#-----------------------------------------------------------------------------
#-- skroty
#-----------------------------------------------------------------------------

DROP TABLE IF EXISTS `skroty`;


CREATE TABLE `skroty`
(
	`skroty_id` INTEGER  NOT NULL AUTO_INCREMENT,
	`tytul` VARCHAR(255),
	`slug` VARCHAR(128),
	PRIMARY KEY (`skroty_id`),
	UNIQUE KEY `skroty_U_1` (`slug`(128))
)Type=InnoDB;

#-----------------------------------------------------------------------------
#-- skrot
#-----------------------------------------------------------------------------

DROP TABLE IF EXISTS `skrot`;


CREATE TABLE `skrot`
(
	`skrot_id` INTEGER  NOT NULL AUTO_INCREMENT,
	`skrot` VARCHAR(2),
	`opis` VARCHAR(255),
	`kod` VARCHAR(255),
	`grupa_id` INTEGER,
	PRIMARY KEY (`skrot_id`),
	INDEX `FI_skrot_grupa1` (`grupa_id`),
	CONSTRAINT `fk_skrot_grupa1`
		FOREIGN KEY (`grupa_id`)
		REFERENCES `grupa` (`grupa_id`)
		ON UPDATE CASCADE
		ON DELETE CASCADE
)Type=InnoDB;

#-----------------------------------------------------------------------------
#-- grupa
#-----------------------------------------------------------------------------

DROP TABLE IF EXISTS `grupa`;


CREATE TABLE `grupa`
(
	`grupa_id` INTEGER  NOT NULL AUTO_INCREMENT,
	`skroty_id` INTEGER,
	PRIMARY KEY (`grupa_id`),
	INDEX `FI_grupa_skroty` (`skroty_id`),
	CONSTRAINT `fk_grupa_skroty`
		FOREIGN KEY (`skroty_id`)
		REFERENCES `skroty` (`skroty_id`)
		ON UPDATE CASCADE
		ON DELETE CASCADE
)Type=InnoDB;

#-----------------------------------------------------------------------------
#-- img
#-----------------------------------------------------------------------------

DROP TABLE IF EXISTS `img`;


CREATE TABLE `img`
(
	`img_id` INTEGER  NOT NULL AUTO_INCREMENT,
	`slug` VARCHAR(128),
	`img` LONGBLOB,
	PRIMARY KEY (`img_id`),
	UNIQUE KEY `img_U_1` (`slug`(128))
)Type=InnoDB;

#-----------------------------------------------------------------------------
#-- plik
#-----------------------------------------------------------------------------

DROP TABLE IF EXISTS `plik`;


CREATE TABLE `plik`
(
	`plik_id` INTEGER  NOT NULL AUTO_INCREMENT,
	`dane` LONGBLOB,
	`slug` VARCHAR(128),
	`typmime` VARCHAR(128),
	PRIMARY KEY (`plik_id`),
	UNIQUE KEY `plik_U_1` (`slug`(128))
)Type=InnoDB;

# This restores the fkey checks, after having unset them earlier
SET FOREIGN_KEY_CHECKS = 1;
-- phpMyAdmin SQL Dump
-- version 3.1.5
-- http://www.phpmyadmin.net
--
-- Host: localhost
-- Czas wygenerowania: 14 Gru 2009, 08:52
-- Wersja serwera: 5.1.35
-- Wersja PHP: 5.2.9-2

SET FOREIGN_KEY_CHECKS=0;

SET SQL_MODE="NO_AUTO_VALUE_ON_ZERO";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Baza danych: `noth`
--

--
-- Zrzut danych tabeli `grupa`
--

INSERT INTO `grupa` (`grupa_id`, `skroty_id`) VALUES(1, 1);
INSERT INTO `grupa` (`grupa_id`, `skroty_id`) VALUES(2, 1);
INSERT INTO `grupa` (`grupa_id`, `skroty_id`) VALUES(3, 1);
INSERT INTO `grupa` (`grupa_id`, `skroty_id`) VALUES(4, 1);
INSERT INTO `grupa` (`grupa_id`, `skroty_id`) VALUES(5, 1);
INSERT INTO `grupa` (`grupa_id`, `skroty_id`) VALUES(6, 1);
INSERT INTO `grupa` (`grupa_id`, `skroty_id`) VALUES(7, 2);
INSERT INTO `grupa` (`grupa_id`, `skroty_id`) VALUES(8, 3);
INSERT INTO `grupa` (`grupa_id`, `skroty_id`) VALUES(9, 3);
INSERT INTO `grupa` (`grupa_id`, `skroty_id`) VALUES(10, 3);
INSERT INTO `grupa` (`grupa_id`, `skroty_id`) VALUES(11, 3);
INSERT INTO `grupa` (`grupa_id`, `skroty_id`) VALUES(12, 4);
INSERT INTO `grupa` (`grupa_id`, `skroty_id`) VALUES(13, 5);
INSERT INTO `grupa` (`grupa_id`, `skroty_id`) VALUES(14, 5);
INSERT INTO `grupa` (`grupa_id`, `skroty_id`) VALUES(15, 6);
INSERT INTO `grupa` (`grupa_id`, `skroty_id`) VALUES(16, 6);
INSERT INTO `grupa` (`grupa_id`, `skroty_id`) VALUES(17, 7);
INSERT INTO `grupa` (`grupa_id`, `skroty_id`) VALUES(18, 8);
INSERT INTO `grupa` (`grupa_id`, `skroty_id`) VALUES(19, 9);
INSERT INTO `grupa` (`grupa_id`, `skroty_id`) VALUES(20, 9);
INSERT INTO `grupa` (`grupa_id`, `skroty_id`) VALUES(21, 10);
INSERT INTO `grupa` (`grupa_id`, `skroty_id`) VALUES(22, 10);
INSERT INTO `grupa` (`grupa_id`, `skroty_id`) VALUES(23, 11);
INSERT INTO `grupa` (`grupa_id`, `skroty_id`) VALUES(24, 11);
INSERT INTO `grupa` (`grupa_id`, `skroty_id`) VALUES(25, 11);
INSERT INTO `grupa` (`grupa_id`, `skroty_id`) VALUES(26, 11);
INSERT INTO `grupa` (`grupa_id`, `skroty_id`) VALUES(27, 11);
INSERT INTO `grupa` (`grupa_id`, `skroty_id`) VALUES(28, 11);
INSERT INTO `grupa` (`grupa_id`, `skroty_id`) VALUES(29, 11);
INSERT INTO `grupa` (`grupa_id`, `skroty_id`) VALUES(30, 11);
INSERT INTO `grupa` (`grupa_id`, `skroty_id`) VALUES(31, 11);
INSERT INTO `grupa` (`grupa_id`, `skroty_id`) VALUES(32, 11);
INSERT INTO `grupa` (`grupa_id`, `skroty_id`) VALUES(33, 12);
INSERT INTO `grupa` (`grupa_id`, `skroty_id`) VALUES(34, 12);
INSERT INTO `grupa` (`grupa_id`, `skroty_id`) VALUES(35, 12);
INSERT INTO `grupa` (`grupa_id`, `skroty_id`) VALUES(36, 12);
INSERT INTO `grupa` (`grupa_id`, `skroty_id`) VALUES(37, 12);
INSERT INTO `grupa` (`grupa_id`, `skroty_id`) VALUES(38, 12);
INSERT INTO `grupa` (`grupa_id`, `skroty_id`) VALUES(39, 12);
INSERT INTO `grupa` (`grupa_id`, `skroty_id`) VALUES(40, 12);
INSERT INTO `grupa` (`grupa_id`, `skroty_id`) VALUES(41, 12);
INSERT INTO `grupa` (`grupa_id`, `skroty_id`) VALUES(42, 12);
INSERT INTO `grupa` (`grupa_id`, `skroty_id`) VALUES(43, 12);
INSERT INTO `grupa` (`grupa_id`, `skroty_id`) VALUES(44, 12);
INSERT INTO `grupa` (`grupa_id`, `skroty_id`) VALUES(45, 12);
INSERT INTO `grupa` (`grupa_id`, `skroty_id`) VALUES(46, 12);
INSERT INTO `grupa` (`grupa_id`, `skroty_id`) VALUES(47, 12);
INSERT INTO `grupa` (`grupa_id`, `skroty_id`) VALUES(48, 12);
INSERT INTO `grupa` (`grupa_id`, `skroty_id`) VALUES(49, 12);
INSERT INTO `grupa` (`grupa_id`, `skroty_id`) VALUES(50, 12);
INSERT INTO `grupa` (`grupa_id`, `skroty_id`) VALUES(51, 12);
INSERT INTO `grupa` (`grupa_id`, `skroty_id`) VALUES(52, 12);
INSERT INTO `grupa` (`grupa_id`, `skroty_id`) VALUES(53, 12);
INSERT INTO `grupa` (`grupa_id`, `skroty_id`) VALUES(54, 12);
INSERT INTO `grupa` (`grupa_id`, `skroty_id`) VALUES(55, 12);
INSERT INTO `grupa` (`grupa_id`, `skroty_id`) VALUES(56, 12);
INSERT INTO `grupa` (`grupa_id`, `skroty_id`) VALUES(57, 13);
INSERT INTO `grupa` (`grupa_id`, `skroty_id`) VALUES(58, 13);
INSERT INTO `grupa` (`grupa_id`, `skroty_id`) VALUES(59, 13);
INSERT INTO `grupa` (`grupa_id`, `skroty_id`) VALUES(60, 14);

--
-- Zrzut danych tabeli `img`
--

INSERT INTO `img` (`img_id`, `slug`, `img`) VALUES(1, '1-duze', 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);
INSERT INTO `img` (`img_id`, `slug`, `img`) VALUES(2, '1', 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);
INSERT INTO `img` (`img_id`, `slug`, `img`) VALUES(3, '10-duze', 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);
INSERT INTO `img` (`img_id`, `slug`, `img`) VALUES(4, '10', 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);
INSERT INTO `img` (`img_id`, `slug`, `img`) VALUES(5, '11-duze', 0x89504e470d0a1a0a0000000d494844520000031f000001ae08020000007ecf2c0b000000097048597300000b1200000b1201d2dd7efc0000000774494d4507d70710082d21438616b1000020004944415478daeddd6d905cd75de7f17fbb540b45008d7713421616b5803c100d563b26d1e004a6c76483161c325e24306fc8a48ada174489863c598995744f320e4a62c24c22a7f2822a8fb678918db5abf1c621025c993bcb628f8383afb2a3c4c159dc431cb2e06cb987c5842a5ef4be38335747f7f1dcc73eb7eff753aa56cf9ddbb7bb6ff79cfeddff397d6e6bdbdd1200000014e1d4e299032272e4e831f6050000404e4b4b4b227240fd70f5ca63ec11000080fc6e601700000014e880fec36b4efce7fc5b6cb55aa13f6a8b034b5aad6b4bf52d5cfbffba25d7b629d76d21782fad882d5cbf91f08d273e05dfe38f790a21f79eb41382cf48db88e953f33d85c497c0fb45cc4ef03d05b39d60fed492de45911b096c33ea2924bd04264fcd77ef31af6fd8fb2dee1d1bf31462fe2e929f9a6f49d23bb6983fbab83fa5564ca311f64797f08e8dd909912f41e04f29e42588dc09c6efd8e2dabd7cef4cd3a7564cbb97fc8e4d6a7932fcd145b57b49efd86bdb346ef7c2fe9492dea226ed9eb44cdeb105b57b89af4e097f7439dabde053b3d04dffeac9f07415f44fdff854d4afbeef277f9b700a00001057bb0a46abd95e6f77389c1571a7a67c57561f7c50060332160000a8c66fbcfaa0f9ca7373731b1b1ba9d6ff4f1f5dcf702fea56a6e9aad3e91c5e5810915d91c322fa954dd75dd8dd1d0c065f7a86d71a000054c4f07b7817d72f675b3fcfad92d3d53f7de35372e9d2dae1c39dd3a73b8b8bde15f55b777575a5dfeff7fb63dcbffff72b1ff7aebff0e83b2d79d5ffe6d17b44e4d0ad67f36ce47fff8f2511f98959ffee7dcae989c84be73e58cafbf5f27b4564faf8ef46adf0953fba4b5db9e9973fa2ae5cf9fc7b44a473fb47c7b8c31ffdecdb45e4677fed93eac747fecbdbbc5fbdf6cef3344300001199eecc44fdaa8c893f23bf33d8e9743a9d8e88b8aeebaeac88883b35d5190ed5928576dbb7fef34fddf7fc53f7793ffee35f457eb0fdc3939ff887273fe1fdb8fbb54fec7e75d5fb71f8d5d5e7aeae983f8117def48e17def48eea5fa7671efbf037b73e6cb8f2e0cf3f34f8f30fe5bcc7bd68d55d1acbfb5245ab9b7ee92337fdf247bef2f9bbbef2f9bb2cf983f9d95ffb84883cfad9bd5075ebaf7ff2d65fff24ed0800a0a858e64b66c12541e1b52b55b8dafb6173d3dddc1491ce70e84e4d8988bbbabab8b0301a8d82377cfea9fbbeff65a7267e5f3ff3d8879bfc5653b5ab96b4f8ab0300d445688d2a31276dbb5b2a4ea99babf513cb5de1e9ca2b5ca9eb323bebaeee95975cd79d9f9a8ad9e23ffed5793d60fdbfaf5f2b24fce02baef5daa8f2d5c19f7a7b517bed3b577e4ffff1459d77a92b7fffc4bddec217dffc6e11f9bbbffc9888fcf02deff93f5ffea888bce496bbbefde58f88c84b7ee6ae6f3ffe1111f9b7af3e23227ffb17e7bceb3e3f7aec7df1016be7916575e5d06baf7511aaf255fb75ef1ffccfebea583ffe731ff8eb3fdbebecfb899fef856ef01b4e5fb4c2d5531b1fd07ffbf2db3ef4f52fbe5f5ff28ad72f3ff9f059efbabaf2d53fb9db5be1956fd87bfc57fff87dfe77d2e5f78ac84fff877322f2bfbe70c6bb2e225ff9a3bb54ed4a448efef2751d82eee7de2d229d377e4c449ef8dcbbbde5affa957b45e42f1f7ca788dcf2a6dffbb2ba32fff12fafbf43447ee68e8f8bc85f5cfa1d6ffd57ffc7df17912ffdd7457de3c74eac8ac863174f8bc8cc895511d97ae0ed223273f21322f2b3bff689473ffbf6473ffb36af7f1000800263995eaf32e9490ce919fca76f7c4a7ada67fcecac37dc4a54e16a71717676b61de81c7cc14bdfea052cfdca0fbcfc6d3ff0f2b789c83f3ca927adb7ebd16af7ababc3afae0eb52ec26c5ed479e78b3aef149167dd7bbd68f54337bf6b2f573df1b16a5e8943b79e5543af76fe7cd95bd87eedfbdbafbb96810ebfee03875ff70111f9eb3ffbe08fffdc077efce77bb23fe22ad14be73ef8b2db3ef8b2dbfc03b05efe0b1f7af92f7c48449e7cf8ec2b5ebfac72958a595ffbd3bb45e4956fb8e7956fb84744befa27eff3a2d5915ffcf091e8e156ba9b7ee923a1cbdd87dee38b5637bff1637bb9eabfbf2b71b3afbee3f7d53f11f98bff762d69bde657575ef3ab2b5eae0200605c01cb3c5a4968ed4a2f5c2d3cfdb47e4515ae06834168b7a00a58fae82b73075f795af5330503d673dbd78661fdeb9ffe9d52779f2a5fa9aa95ec17aebef5a56bc9e3478fbdd79e17fbafbef8011179f96d1f2a76b3d3c77f77fbf27b55d54ab4c255143d5a65a3d7ae621c3bb1fad8c5d35bfb494b15ae0000289b57b8f2ba0853a72bf7e85171ddf0cfd1d5d5c58585f82d7effcb4ec50c69cfe0c6e9c5e00cb0f9a96e411151dd82317ee4357b89caaaa96255b47ad96d1facd1f827d52d2822aa5b5079fcd23b4464af7075e977f81b06005818adbc715726012bec3b83172eb877dca1fec9d252e7c107bd7f2bf3f3ed767b7676b6dbed067b06f58065f36e7af1abf64605fdf02deff9e15bdea3aebfe496bd2fc17903ad42475c45f9e6a3f77cf3d17b2a7b0a6adc55b067b0285ebd2ab17025fb3332b8da58aba057bd696f54dc2d6ffabd5be6f7a6d25083ae525183ae84c21500107a3a33be7f65472b3d63c5df2aa476a54fbfde6eff6db7dbd57fabba05078381c96352752c6f60bb1ad5fe83af78bb37294381a3da43fdd0cdeffafb27eef506b6bff8e6771752e8f186b47f73ebc3ff6ee67d89ebb75ffb7e6f52067de895b99fecf6bfe1f49f727afa8c0caa7c25669d833ff5efeff9da9fdeed0d6c57a3da8ffce287affef1fb8203dbd3eadcfe51f7a1f7b89f7b77e78d1fbbf98d1f7be273eff606b6bfea57ee8d2ffafdcc1d1f7ffcd23bf254ad7c535e0100109593d20a96a94c7a065bdbeed691a3c7d49ca4c1b338bf61fa6fe7e7e77d0b0f1d3aa4ae2c2d2d7de99957fab758d5599cd56ca27b935d15771667fd6b83f14fa1e2b3385ffbda60f96771d6bf3618ffa2547c16e76b5f1bd436a2a72bb558cd29ea9b4d94b3380b67710e7b0a9cc559388b336771aecf599c7fe3d507cd6751771c67636323d5fade997032dc4a9dc5592d49388bf3a14387666767af2bc3ec7708ba1163b32af61d95b1ac99abbd3c2fed2e3de5f49e727a25cdd55e533173b50300264fd4c9678a5a3fcfad3c09e96a7575f5c61b6fd487586d6e6eaa2bc3e1703018c881578e6bfffe9b9bde114cf4f9a51a6e557dc02af6c94631196e3516deb82b8f9aabdd3b00f2266a6fb598ec140026cddcdc5ca9ebe7b9558a74f57d3ff9db312713d44768010000944af5c1d97f2f0712d72042010000644c575fbaf89bec1100808191c112a0a16e601700000014e880c94a315344189e700700008074752d5acdf67abbc3e1ac883b35e5bb323d7fa70c06642c000050b623478f99af3c3737b7b1b1916afdf32be732dc8bba55ba74d5e9740e2f2c88c8aec86111fdcaa6eb2eecee1acedb0e00009093f93c9fd9d6cf732b4fc2b8abe9ce8cf47a6b870fbb2b2b22e25d51dcd5d585a4933afbb71676bd10259d60a8a44755c1a3b5738780970900c6d8e456706ac2e474d5e9743a9d8e88b8aeab72953b35d5190ed59285e81339fb9e43211f2745ed91a26e1bbc5eea2765a9d974ecbbaee2cc91ed5d94ff5195fdf79cf8d70700c8d09cc62f093a10bfc5cea54b7b3f6c6eba9b9b22d2190edda9291171575717171646a3b8afe07ae3b1a63b33bef34b6753c800aff246895533fe4cdf99159b8c0176fa0e4cb533733efdccf79bf3c51ae31b06006ca3b78726c79fdbee968a53ea86ea26898d6a5cbaf20a57eabacccebaab7be721715d777e6aaa907090b3e90f26cae0878ab78eda47de7ed19717fbb11d7cc1a2ee2bedd30feebde04769fc5deb0f3278c5b7a6efed18b566517b2f78ef510f2cea4ada1da8de12de1b236a67e67fe744ddaf6f85c48751f81e0e3ebbf8f715410d404d8fab33b7665ec032bfe18198c771ad702522b3b39dc5c56be96a7575a5df3f74e850c56598a84f59891de114fc54cb7c70af7f18fb2ea3125e4cd1227fb4f26dcafcae0dab1d890fbba85d17dc8eef55aba00c13b333f5774e1925a8d0e26efcab5048e52c34a4c6bfaf00a099152fc3aa5542bad20b570b4f3fad5f5185abc16010df2d9898103334d989eb47251e93ba57f5397a8c9f5851b9306dccad6687448dcd1ad7077fb14f3ff12964bb3baa4d00101521d20e4bd54b5fb96a57eed1a3e2bae1bf5a5d5d34fbaa6062a5648c09c3a4ee5541104ef5f44bdd63a97648e18f21a63f7becaf54d94f3ffe65cdfcf4095500504823e91b1962f2411c3deeeac205f7c2057555af6389c8c2fc7cbbdd3e74e850bbddce39d9551971a1ecd0a66f3fe77d8d256015f8f825fda8f0f8bbf60d3c2ae32984f67c55f0f4e3ef97de3700c8d002577054e93becf70d724f9daef49b9ded9feb76bbfa6f55b76021f388a6fa5cf18df935f9300e1d6865fe419ef919993c869c012bb8d954779df8b0d3eed242fe487c4fc4f055cefc02c57c45c0e49d93e1858bba61d4d32ceae9677b27c4ef0a00a8751a336c3c3364b8d6b6bb75e4e8b1f83949cff6cfcdcfcffb167a43da9796968273c08f77f7258e62e1130219de15bc730060bc12138be7e2fa65c77136363652adef9d0927c3adf4254667713e74e8d0ececacbea4bd3f8fa81b31364b4a28d915b2c162278028f60956f0f4eb724851de53cb33996d053bbcca57396a57902001d82ceae43345ad9fe7561ea374b5baba7ae38d37b6b599d9373737d595e17018d53f58d2c0e79cabe57c5463fce099eccfbcca9e5d9e417213f62a93a200d4cedcdc5ca9ebe7b955ea74153ff283361a000054a09a9148f9efe580e17a44280000001337b00b0000000a745ded2ae7182e00008006eaf57afad70c0f047fcd3e02000030b4b4b4e45b1232ee2a668e078a5b00000027e68fc7fcf640aa6d51d9020000889f6e34325d1d397a4c44969696f47466387529d010f9abb9beae7ab0c39bf3f4f9f3c1043b9039970190a4e230d8e13cfd897c3af9cffec93c47938d1919f60ea154adae761b6fc823645fb1af7884a019478d1c601700767e54e847f6be1fabdc883a46f78eb37d3fc2066fedccdce76edd3e7fa77ebe32257eca69f3024ccc2b5ec8466a6a341a65b855abd5e24d4bba920c7f99f9ff84bc2d9b6caab2bf6d4e07a49fc9d8fcacc6a59ecf3beda64cde5a459deadb9748323c5adf79dacd4fdb5ef8466073b4ea8b3cdb996977bbbe2cf5ec73dffd83b5cffcd6c29d516fd4fbefbfbfdbed26de85e338517f14856c64ef9dd999b96af00762b81a50e374159adc5bad56fe0f27df4778e2069797e5ecd9c88f2e6f23393fd1a30e53381049f53ec9f60ef1bd7c6a7bad56f6a415fa188a2acc8c4623dfbb22b8a416615abfbebcbc7cf6ecd962775449473bcd39f8796b6746441c114724f8f61a0c06a3d1e8f6f93b1f5aff4cf0b60b0b0bf3f3f3dfdaf97ae2bdb4dbeda8fcb4b0b0b0f396b75c103911bd932f766644e484bb151fc2aeba5b89c92967b42aaf2200149cae623e5a32bf5ff51be64f45691be278a11f99fc6596fd0e99eecc2c2f8bc8b2c8d9b367653412f53aa82bcbcbcb226745964d429bfe8ef2ad5f6062080629f368a57f91ca37439dfad1a46baf908df878d1ca926c54e5df5de6ea63d9ba2227dd2d113929726af1cc91e7bedbef8bec8798937748fbc285e1ececa9c533a15d8457ae5c79e1d4f7fecbe87b76777743b77ff0e04111d9dc4cfe729f17a1be33fc677db9d3edaae526df108c0f5805462bf53ae62c040055a72bf54162f2c64d6cb38a4a45aab895e7cf52555fb2f5b29b7f104a415fa299ee3cacb523af2ff663265be455ef0ab5035bad7b4496533ec86591bd0ae5d52bb2ed8a88a82baaac2262fa027b0dabfe2e2d2a5af9ea3dbe7d55486b5e48d79ee1461e79e4915b6fbd35eac73c6af8a9360a2b0f8dcdde28ab6e7773f18c57611291fee69cb339ebf41c1179b6735777a3ef38cecece4ed4765e70f0c531bfdddddd1d0c060909cf719cfd3c77b133a3072c2f5a3dee3e69f8bca2025649552ba036e9cacb1f8907ebd39d199558445aadd64c68fb6b55131cd5d793e78359452b7d9a565f69e1e2fae5c4bc35dd79d84b272ab2e86145ff6dfe4fc4cc07f1de1b63341ab55af78c46776b3bf61e8307795605ace8563245c0d29f4be16589c9e816acac1a348939ac0aed763b38ca6a7d38747ba3bed395a5ae88a88c25e2246e6d6d6d4d446667670f1f3ebcb6b676faf4e9a86a56a8373ffdf4cece8eca522a60ddbbf2e9f6da9a4a5abe6a56724b2b32ba3e4ba96845a9098d4e57990e0747a351cbbbae2eedf9348a2f5ca9a3f9471e7924f35fbe8a565e21e1c4fcf123478fa9795c55f6322933a874129a51a296577c1478fd0bba1c482477b75af7c43ec86591b35e2760e0525245abfc613166cfe8cf3474498d3e217c95aaa20a5775c94cc1b77a86374c65df86190c06aeeb3ef8e0ba1ceaf765ce9159f3dbaeadadf57abda9a9a9b5b535753d55ba52fa227d754cd89969e77b2e7a058b61ec205d65f9ccf5852aedd2a2e6352aea79d12ae7a78e2f3c5dbdf29817add23cd4878bed048c4924193e15ae1fd87e8f84f415c63f85ebe2d4d9b3cb5a4af32ecf6678718b0a3d6a6b7a99ca7b63f86a57b53b045f5e5e9ebf7def75597fe8e1420660d5a776350abbdecab111c9ba91100f5cba3609d3c93ba4dd6e0f876bdd9d25a7b72122dda5ae741dc34d0d87c376bb7dfaf46955c7cae6b9d3a76f5c5ddd3b500c8cc14af5f6d876b78e746654d2d27bf0b3bd1f8a1ac20bd4255d5d8b53ad96d7dcb442dbdfc4af0d46fdf12c2f67ff0078e49147e28fec8b0a583ed9ce115141c0523d8f19ee2858bbd2fa0aefd65357d42b7c7dc012bd6f71ffb6cba95e5cfd7d35dd99b130f4785dc6c113b057b311f5c6f6a29588ccdffefab367cfe67fc3173bc4adccfb6a5ddf58e5dc48891eb874acdb9576db71da0b225d11e9f6fae298a6aba9a9a9a9a9a998315826bc682581315885bc3df2bc94042c342a5d5d8b5631192866b6854252547c7e4a5c213e8125f29dcc51f29d7e2b987b0a8f5cdbeed674e7e1e000af841c1d51bb0a5d21f45d100c5881bb48ec5e0c8f565ecb5b6cc0ca993ff42ee30cb5cc423612f514f21f4bd4e23b83f9672c93b1d6de1ce9760d065d290b0b0b39a3557fffca09776bba33d3cf17b0bcb156a3e2fe2af5afb000939dae0a8b566acdc2835730397df18b5f54576ebbed36ef63e6d65b6fcdf6f7af3ef07c43d7d5d0ab344dc6eb2b78a9f4aff879776a18dd025dabcb92fa0b9821d1cadbac71f762dc27652187b6be67aab69979106121d37e66de48a9b186e1c9e5c6aafd50e588388e93f80ed4bf58a35f4f7197fb5f1b5471aad7ebbd7961e1c2e1c32a600d3245ab6b87e00cbd02e92ac3875121d1aab22395bbefde0b718f3efa4821c7f15e96d23f050b9c4dbb90ece545165fc6caf639aa3692bf76a5dfc4ac7b31e1cdb09def7b49faf82abd2a26fbdf8d30895951d93a55e62e6423c173e014783e9c1a7e67b036dffadcd9d9d1a75168b55a89b32acccdcd79852bfdbaa10b870febd1cadb883e5943aa63eeabd78fb26a756646149c40ba4a93ad4a8c5685884d4e7bbf2a7c547b431458bbcab04d1be6a84cfb7e48f53ec9b991e038625ff4cc9944eb33eecaaa84676430189c5f39a7ce90f3a2a447fefceedf1d3c7830ea1b82c3e15044a6a6a6323f98aee3a8f295da54e25b2e6af285abeed6a833d362520634245de59f3721a63b6fec7f45eaf323665895379ebd697ff06a9607c951188baf3085be10eafdb27f99a16fd13413640e0df17f0ed9fe58bc532f07af94bd11df772aa352d7b8b2119fb209b14644f64ff01cb5ced1a3470783c1e6e66654f499d2c46ce4e0134f3c78f3cd5113b24fadac3cee3e19bf11f5827a1d82dbdaa5774505acabbcb498f87495b3752b70a062544bed2dcffc15f2c4b1380d8956c13895a7c331c36d7d3b79baf370aa7c96ea8d97f92bdfe5bddb8f1c3de64d7e663e0b5ace8d0467b1b7aa76d57083c1e0814b5f10f982bed071ae8db272441c919868e5ba6e7cb412ad76e5ba6efc46a4df8ffacec470381c2e2e9e70b7fa7d37eefd6930b8cae45c84e6ef3dde84b0345dd9f4d9bf55d38dd72b60f160aae78d940a5ea97823c1d332f2a731460fad7fe6d4fe3970746a94d5039d19898d5622f2876b9f9eeedcdc351817e5384ed46b6dba916eb79ff48631cc4c0c6f47bdd3559ef9750014c82b2f05af94b791e0f1bdeff4eabc2e63177a6266cfc9aa0e1d79330029d25521e712ae5179a0bc71e5a56ebc218f907dc5bee211c2c2669cf3872275ba029028dbcc406087f3f4793531d95adbee9637b235cf14e10000008d3df8f1a294e33807389200000028d075e98a91ec0026e3f011006c495722e2189f501d00ac12ff1d3a00185bbaaaa08552c3bcd45c3b2f78e95b790d0084fad2c5df345f3974f227613829804af8665ae03b8300ec6538e569d4a8868beb971b35b90c8071f1b536a42b0056631c1580dab9815d00a051a63b33debf54b74a5c02000ab52b00cd8a569c2d11687823a0ff58520b40ba02d05caa610d6d6dbd85be34166c8e7d6bea5bf396783721cf0176fee19b1f9599fc2193ae00d449ce81eadbee56302105a34f681e8affad7e9d2c054c581a4b7b8cc4b82b00758a56927b92856d774bb595be2357bdc5f4560816a2f2443ac21650eb8065fe575c6eba4a3b6e1400e2a355f07ace8c15d576a915084300f48065d826dc50f643e1f500506cb4ca13b0e2e354fcfa798e1553b5cb004ae2d59fbc3fe7b4a3af0cd767dc15801a38317f3c7466d1b4b361f91a477d70ab3e385d1f9ea52f0f1db3153afe1d8085328f89d447559adc967405a01e8a9a5634d82c863694fa182cdf65e80aa15b236f0113c017a74c0216a3da01a0ead619408d181e9291ae0060ccad338009fe932cb167d037648cc605405a51a767367462fe78fe6f170280496b5351ba224e01c8e3d4e299c29b3c00a800a3da0158eafccab923478f5dbdf298f9a57e73aa5600aaa41fcb91ae00582a4fb412915eafc73e045019bd15225d01b0b7a9ca13b08a9ac1a13cf9ab6bbd5ecffea7093410e90a80a572d6ae6a816161c04462460600964a5bbbb2ff195d5cbf5c8bc70920276a57002cd584da55a8b77666ee73b76e9fbfb3dd6efb7e757ee55ccc0dcdcf9816f39dee42360290ae00c04639c75dd5375af5459eedccb4bb5d5f967af6b9effec1da677e6be1cea85474fffdf777bbddc4bb701c27e6acd5f93702807405c052cd8c5622e2883822adc06f0783c16834ba7dfece87d63f13bcedc2c2c2fcfcfcb776be9e782fed763b2a3f2d2c2cecbce52d17444e44c7a68b9d191139e16e998430807405001629af76e5757ed9567ae98a9c74b744e4a4c8a9c533479efb6ebf2fb21f624ede21ed0b1786b3b3a716cf8476115eb972e58553dffb2fa3efd9dddd0dddfec1830745647333f9bb8a5e84facef09ff5e54eb7ab96339d1840ba02503f25d7ae4661e5a1b1d91b65d5ed6eeecf50af065df537e79ccd59a7e788c8b39dbbba1b7dc771767676a2b6f382832f8ef9edeeeeee60304848788ee3ece7b98b9d193d6079d1ea71f749de9f00e90a40fd346adc55bbdd0e8eb25a1f0edddea8ef7465a92b222a638938895b5b5b5b1391d9d9d9c3870fafadad9d3e7d3aaa9a15eacd4f3fbdb3b3a3b2940a58f7ae7cbabdb6a69296af9a05807405a0360a8f56c16fc365e8228cf94a5db1fd8c83c1c075dd071f5c9743fdbecc39326b7edbb5b5b55eaf373535b5b6b6a6aea74a574a5fa42fa202569bb72340ba023001caa95d8dc2aea7ed221c852d2ca09ff1814bd766c33a7987b4dbede170adbbb3e4f43644a4bbd495ae63b8a9e170d86eb74f9f3eadea58d93c77faf48dababea7a700c168028cc260ac052e5740bb6f6fff9aea7d20afb57b0072e1d13e9b6db6d67b6e748d791aef4fae298a6aba9a9a9a9a9a90c252b9d17ad44e46267e68553dfcbdb1230516eedcada2fe600b05fe1b52baf21cad3348db13573a4db351874a52c2c2cc40c6f37d1dfbf72c2dd9aeeccf40383dc018c215de913cd31e91c80b41a3b577b48acda0f558e88e338ad5642a9acd7eb855e4f7197fb5f1b5471aad7ebbd7961e1c2e1c32a600d787702e34a57442b007994fc9dc1565df6c3cece8e3e8d42abd54a9c55616e6ece2b5ce9d70d5d387c588f56de46f4c91a008c275d11ad00e4515eb4aa57a334180cceaf9c5367c87951d2237f7ef7ef0e1e3c1835dc6a381c8ac8d4d454e607d3751c55be529b0230867445b402905933cf3318196b4464ff04cf51eb1c3d7a7430186c6e6e46459f294dcc460e3ef1c48337df1c3521fbd4cacae3ee93f11b014857442b00366a54b41a0c060f5cfa82c817f4858e736d949523e288c4442bd775e3a39568b52bd775e33722fd7ed4b96e86c3e17071f184bbd5efbbbc4b81aad3955c3fed1e490b402a8daa5d3db4fe9953fbe7c0d1a951560f746624365a89c81fae7d7aba73b3c999951dc7896a904d37d2edf6397e06c692aef8c3039047d3ba05434fccec395955ab4bd30de4c76ca2002c95b67665ff333a317f7cb20787015038130e004b4d7ced2adb4c5400485700905121e3ae2cac69798f933a1640ba02804a1512ad2c4c30a716cfc40fb10240ba028052e4ac5d59db5dd8ed764f2d9ed9d8d8a87e7fea3b678cf70e90ae00603c267bdc55f50fd8ab998d657751b143a3f09d4100f6e68f09fbcee078a99ad9b892a8ba775e0590ae00609c4aaa5de9b31ceb4b7ccbbd1fa73b33fabff88d84fe0a40d3d03308c05296ccd5ae66d7e4d45e00cc51bb2adef34fddc74e00f22b295a6dbb5b7a7929736cf26d24fff30d56c8f485a16b16b5aba3ea7600b2b1a276a5c79117bcf4adbc2a00a4ccda950a58dea50d4fd6f748820fcfbb1eba1000e9cacf4b549351f52120028528b55b30345aa5aad9f8225ab1f59e60660a4d51442b8074050029943aee2ab476e5ab1ef11278fb41af96e9fbcaf75b00354b57beb296af3ea47eab167a6b86ae13fc9577dbe0465255a1e2fb377df712bf9af7dbe79fbacf57d80b7de4053e0bc01e65472b89a860992bbb6f512f8979f712bab0bc68a5774786764a12ad80aad355514d801e32429778a9c2174742affb7e54b7f596f8d289793489efdff4dd4be2a30a0d94314b8a7a16803d4aaa5d05eb55368f5e0a1d6255d9b82b6fe7046b5700c693ae8a1a7a191a0e7c759da8c815b585e0cda3ae172bf161c4ac9c76fb242ad45d2de66a0f6dd9f40852f7d28e2f7d52a9024cdc50eadf64c54fa6ee79c2ab3fa97fbc3bd17025cdd51e3560dcb73cd58f727dcf9dfe2ff3d1a944148aaaac1e79c3aa62664f058d85f778000018f9494441541074a0b23fcef13ecfba8495988e42a06926fb3c83c17016ac785536ee2af4def5e5318f07c018d29525d31cd731a6c4f71b0213cf92b9daab0c5879169671ef92be8607404aed19a46e9c16bd8180ae51d10a00e9caf448c83b5d439ee39be077e524fdb7f942b730f6fc143a30dffc3992c630d94a1a770500652bb767d024540503879e8aa2e251682889994a2a660ba9a672c8f32cc460be2bdf240bf131519f85a19067015885da1500d25546869ffaf1ab996cc470e2836c931a14b2a6fa55aa67aa07d0fccf02b0ca648fbbaabed876e4e8b15eaf3796bbd6ef1d9848737373e757ce5994ae0020eaf37822a3d589f9e327e68f536c0326c6c5f5cbbe2537b05300d8897157006a8a745591e0c83000f1187705a0a6e819ac08839f80b40a1c7715acdb03404ebd5e2faad9215d01b054b1b52bc771d8a5008aa28f61275d01a88dc2bf33b8b1b1c15e0510d5e098af7c6af14cfc0aa42b009662dc15808adb1c93d596969612d7215d01b0f750928005a0e266a790ed90ae00d87b1c6973b46ab55aeaca6834e2c50240ba02508f83c86a02564c9d3f6a7af156abe5852aefbabe1000e90a00ac5365ed2a3445998cae106a570002984d1480a5c63257bbd7df97e7e6ad56cbdb4e6b5fd40ac175005862ba3343ba0230516c1e77351a8d42239157c7d2fb0a153d60f99604d7016049b4ca16b06ea8ecf101402a15d7aebca8e4cb4caa7f30d84b983912057b12a95d017646abcc31e6862a1f1f0098abb876a5a2927e455143b2a286b7e7a7d7b778d101dba255b63073a0ecc7b7ed6e11b0006460f37c577c3d109860dbee56ce2d9498ae54b4e2450290cd58a2956166f28d9ad217ea5b085d2d6653002643e9b52b9216806caaac5d194ebe9098c3bcbec5a8d5427f45190c205d99f2e214d10a40069545abf2c65401205d95c2fb4223010b402a631977b5b4b444d8029a29430d7b6ce98a5005209bb18cbb225a01cd746af14c815be34c38002c45ed0a4065ceaf9c2b308a91ae00588ada15808adb1cc363b0c4754857002c45ed0a40f5cd4e21dbe13c8300ec3d8eb4b976657efa1aa6b3029a86da15007b0f22ab09583175fea8b0a5cf1aea5d67027700a42b0056abb276159aa20cbf9e4da2026057ba7afea9bb780d00841acbb8ab9cf52775f3a86a56e259710090ae00a044d69ec259a24f2018139b423b13014c2446b503b054dada55cebbf386a8fbc6aaabfec1602fe1689ff9a075f381f0006a8dda15004b555cbb8a1a99ae866415324d03f52aa021a85d01b054c5b5ab54e2eb4faaa015d3fd47f90a986cd4ae00586a2ce3ae0ccb4ba1e3aef4f1ecc14d450dd50240ba02808a54f99d41c3c917127358fc42421540ba028071aa2c5a157bea1b55a02248014d56eeb8abe9ce8cf78f7d0d2095b18cbbca50c4f2515f24e4e5039aacf4dad5b6bbc55e069081e5e7190480287c671080a56a5abb0280d2d315dd8200b2a1760580741562dbdd52ff085800d2a276058074e547a2029087b5b5ab5618c3ed07d72c6366d1a86d328b29508d1247b5eb252bc6b60348abb2f9ae62ea55a1612bf895c03ca9a58c2f18f2a5456062d315a10a401e55d6ae425394612f61cc196f003413df190460a9b18cbb4a5b85d2a395baadafa330aaebd05b12fa2bfdb7c12d242e09de3c78d7868f134006ccd50ec05263197795395af9967857f4ec157a3d6a9b515b086e2766cb51cb7df762f8d80018a27605c05215d7aebcca8daf84a3fa0783bd84a12924744856b04a14135fbc933dc7ac1353670aa6bdd0354d1e2780cca85d01b054c5b52b5fc5c8a38664f9066619167882fd865e7e4a0c58f12b18e6c5e0bde7dc260013d4ae00586a2ce3aed2a696cc492e7ed2849815822bc72fc9f0ec78ef013951bb0260a9b18cbb322f0b99dc3026244515a8823d837ad1cbb7cda82589f71ef3382962011390ae7e8cd70040a8cae6bb929453b447e58fd0e1e4be9583eb240ede3219dd65f29042ef31ea7102a875ba02807095452bce2d08a0588cbb026029ce3328594b4a14a200d2150084b0f63c830040ba02504bd4ae0090ae00a048d4ae0090ae00a048d4ae0090ae00a04836d7ae42cf8b6c2874e5c42d943171288092302303004b5536df554cbd2a266c1578b6e36c9be28b8100e90a00d2a9b276159aa22aeb2524270113869e4100961acbb82bf3eeb6a8f3ccb4f60597f81686ae1f73257e39007b50bb0260a9b18cbbca4f3f3fa0ef64827a30520b7dbf4d2c6215d81d09a03cd4ae0058aae2da955740f2159954ff60682f6168f92a58a68a4960f1292a58b5225a01b540ed0a80a52aae5d058b498a1a921535bcdd9781422b55be8494e71112b0805aa07605c05263197755b6c46ca447a8609c8a1aec05c02ad4ae00586a2ce3aeb2cd8ce0259e60fa89cf43bedb9adf1d152c80740500a95536df95a49f7cc1176e7ce5a5a89555908ab96dccd6820b095800e90a00d2a92c5a957a6e41bd70451e021a827157002c3519e7191c69784d01d215008c93cde7190400d21580fa998cda1500d21500d882da1500d215001489da15809ae23b83002c6573ed2a38a955d46a0c6607485700608bcae6bb8aa957c59c00a790f044fc02485700509d2a6b57a1298a5e4200d930ee0a80a5c632ee2ae759fc5afb6236eb5b81f306029387da15004b8d65dc55ce68a59ff426feba7eaa665e6b60c250bb0260a98a6b575e49c9575b52fd8386bd84c1da956f649577da66421530c1a85d01b054c5b5aba881ea6a4896e17709434fc91c1ab04857c004a37605c0526319775514dfc99bbd1fbdc215c3ad800946ed0a80a5c632ee2a4f4949cf4cbeed78f52a5fcf20752cc01e057e4d987405c05295cd7795b9550ded078cfad1bb1eb30e807139b578a6c0ad91ae0058aab268c5b905016c6c6c14d8e030ee0a80a538cf20809a3638a42b0096b2f93c830068704857009a7e286988da15408343ed0a008792d4ae00d8d5e090ae0034e250d210b52b800687da15000e25c750bb6a5dcf5b68f92eadd143056adde030230380093994cc1cb062ea553161ab9a79aa0a9c6b94694b81ca1a1cd21580461c4ac60b4d5113d64b48b4022a6b70e819043021879285dc69215d66c11e43ef477d79e89aa1eb486ca79e6f23727dc765d43a3177175c13a0c149d5e050bb02d08843c9c2459d5250ef80f3aeab4bef47752574cde095f89a537023be25510f29f47e63d6046870a85d01e05032755a0aade5a8fec1602fe1685fd4a64cca3fc1352b0e34c1bba376051a1c6a570038942ca676e5ab1879d490ac54f3609927240b8b43d4ab408343ed0a008792458ebb2a96790528714dd56d57656f1de52bd0e050bb02c0a16401ccb34b54779e8a41265b3359d337162ab85a7023fa92321e124083c37c57009a7228992760a59d7c2134794465a0e0f2c43563d6317930be51ed517794edee001a1ce6bb02c0a16402fbcf2da8429261ee19e3187980064761dc15800939942ce44eed9c4134eacb89312ba7ba0900ce33088043c9319f6710000d0ee90a40d30f250d4dd8d96f008ca5c1215d0168c4a1a4216a57000d0eb52b001c4a52bb0260578343ba02d08843494386b5abd05329f3920134380a333200989043c9cc012ba65e65de511875c241beb80734b0c1215d0168c4a164bcd014452f214083c3b82b008d3e942ce44e3377f07937546703f42dd77fcb2b0b4c7c8343ba02d08843c96aa8ae40ced60734bcc1215d0168c4a1a44930f2ea4c7a8549f50f1af6127ab98a500534b9c1215d0168c4a1a44930f2ce6dac672335242bd5f076baff80863738a42b008d3894ac8657b8f2052cb584af10020d6970f8ce2080461c4a1a324f3f7a7ef26ee5eb19543feabfe565059ad0e090ae004cc8a1649e809576f285604e8a8a50242aa0810d0ee90a40230e2563947d6e41c6b9034d6b7018770560420e250bb9d3326610f50d930730f10d0ee90a40230e250d955dc702d08406877405a01187928638fb0d408343ed0a008792d4ae00d8d5e090ae0034e250d210b52b800687f9ae0070283986da5570b2d0a8d512c7b333c52830790d0ee90ac0841c4a660e5831f5aaa8b0a5f210c108a0c1215d0168eea164bcd014452f214083c3b82b008d3e942ce44e739e80b9b52fd592f8e5006ad7e050bb02d08843c96a781d855ea7a16f89de9968721d401d1b1c6a57001a712899c8ab1bf90a48aa7fd0b097d0a4fe44ed0a98f80687da1580461c4a268a1aa8ae8664997c97d0577f8abf23f3e5006ad7e050bb02d08843490b452530ca5740dd1b1c6a57001a712869284f01490dab8a8a4ade302cdf92e06d296201756f7048570026e450324fc0ca36f9423006f99684e6a4a8750855c0c43438a42b008d38948cc1b9050130ee0a0087929c671080bd0d0ee90a40230e250d51c7026870a85d01e05092da1500bb1a1cd21580461c4a1aa27605d0e050bb02c0a124b52b00763538a42b008d3894346458bbf2cd6be5fd98612250e60e0526afc161460600137228993960c5d4abd27614326715408343ba02d09443c978a1298a5e428006877157001a7d2859c89de6eca753376f69f45fe94b82bf0d5d2dea86a14b78cf00963438d4ae0034e250b270f169c6eb226cb55aea1c82be25c1750c6fa8ff187a13de39c0d81b1c6a57001a7128699296f4ca93b75cf50f067b09471af3ed8766327d0be6abe9a18ada1560558343ed0a40230e2513a9b0122cffa82159f9e7c10a0d61c1ef1e064b53a1b70aad5711b0004b1a1c6a57001a7128690f3d03a5eac8f34a6b74ff01653438e697a716cfc46f8dda1580461c4a1a2a2ab8f80645a911548977a1af165c123ae22a78130099db1c93d54cbe4d4cba0260efa16465012bede40bbe84141c931e8c508937d17f0c1de76eb86500799a9d42b643ba0260ef716435d1cace730bd20308d417e3ae00d87b1059d3f30ce64f45e65f450440ba020053369f67100062d03308c052558ebbf22c2d2d11b080869beecc04176ebb5be65ba07605c052d4ae008c453048a58a56a42b00f6aaefb82b009314b0d2462bd215007bd95cbb0a4e31153fb5bae19a86f7cb04574065012b43b412c65d01b05665e3ae62ea55057614064fde9c195f2704aa0c58a42b0093a3cada55688a8aef25e4047f00a2d03308c052631977953f27e95b08ed13f42e15efbabe5afc12fd8a6f4d0036a07605c052631977654e9de04fbf34b949f047af06a66fcd0b4fc125a11b64627780740500c92a9eefca5719f2c28a9a01abca79b0cc6b5154ad800215f89561d215004b555cbb0a9e3e5951a12a345af90a4b4531dc2003bf80029d5a3c53e431d2b6bbe5354c17d72f3b8e737ee55c352d26af258018196a577accd2af5f5cbf7c62fe38bb1440e179c6179fd4756a5700ac6eb90aa95d31033b802a91ae0058aac07157d58f7907d064ccc800c052967f671000a250bb0260a9fcb5ab8beb97d98d00485700b02767b49a9b9b631f02205d01c035396b57657ffd1900a230ee0a80a518770580740500451acb790601807405606251bb0240ba02802251bb0240ba02802251bb0250537c671080a5727e67707af947d887002ab37df65bde756a57002c45ed0a404d91ae00588a71570048570050a4326a57a3077ed4fbe72df15dea2bf32a00c8807157002c95ff3c83a15a279ff1c29377ddbb12ba268089e13b6a2ae9cf9cda15004b5539ee2ab46a45ed0a9848ad93cfa40a55c1a620b171205d01b0d4b8c65de9352d00689d7c468f53264d043d83002c5552edca6b2543db47a21580a880e55d26ae4fed0a80a54aaa5da94e81a8f6d177900a00be8065b232e90a80a598ef0a40b1bc2195be6f0d1bded6fce88b7405c052e31a7745f90a98547ae93abe8c1d1aadccdb07d215004b953a1d836f897e19fc114093f93a044d0216e90a80a598ab1d800da28eca485700ea877157002a0b4cc5225d01b014b52b0035c57c57002c95b376b57df65bec4300a42b00b826e779062fae5f661f02a846afd7d39b20d215004be51f77e5380ebb1140d9ceaf9cf32d215d01b054ceda95b2b1b1c19e04507663e55bc2a8760096e23b83006a8a7405c0dec341be33088074050085b1ad76d5ba9eb7d077e9bb09af23d0408cbb0260a942c65d45595a5a8afa55afd78bfad56834d29393f7a3be3c6a7d00a42b0018b3b26b57a1292a26750180217a060158aa46e3ae7c3d80be7e43004d43ed0a80a52cfccea09e96a27afdf41e4300cd44ed0a80a5caab5d79dd7fa103d5638c34442b00a42b0035535eedca1b7135ba5efec73c1a8de80d0440ba0260a99ace7745c00240ba0260a9faced54ec0021a8e51ed002c55ea7c57927ef285d0ae43b550bf0c2e0740ba02002b941aad62a60c05809ce819046029ce33088074050045aaefb82b000d47cf20004b953dee2abfa5a5a5981ec63a063e4a804021a85d01b0f793def2da1583b70090ae00d489fde3ae38e53300d215803aa1769568ba3363b830c3760090ae004c1a6a57f179c83c12119e00d215008850bb8ab5ed6e6dbb5bbc4900d21500a43031b52b553af2559bd48fde92a82bc1e5868277e7bbd354d52f00a9302303004b4d52ed6aba33a34a4dea8af7a3feab02f9ee4e44bcbbf02d2fe3de0150bb0260a9bad4aea22e758609c6cb5e312b98149c084cc07851bb0260a9bad4aea22ecb406c02485700909dfd73b5171b9bf45e3cdf757215502ff40c02b0d404472b9599d43f93d864b24e4c8f617c6f2380c251bb0260a989a95de9d9c837ba3c71b59c5bf62d0caee35b0e807405609235a75b300a7d8200e90a008ad4a87157a1c855404d31ee0a80a5a85d01a8296a57002ca50293e1e5a9c533e757ced9960e791101d21500d8c530a08cf16cca0040ba02503374f901a81dc65d01000090ae00000048570000004dc0b82b00357071fd7270e189f9e3ec190016a27605a0068241aad7eb31e50100d215001413b07abd9ef0754200a42b0028246011ad0090ae00a0e08045b40240ba0280c210ad0090ae0000004857000000c884f9ae00d88bd33303205d0140614e2d9e612700a8a3bc3d83aaf95373fa195e5ebdf298ba94fdd1a95c72c965432ecdffcdcdcd9d5f3997ea1f0d3a005b6cbb5ba3d168dbddda76b7fafd7eb7db554b4ca8f5d5cdb9e4924b2ee32fd3b62dea26a9fe7977e4356823002859304a45a62b9386ccb73e975c72c9a561cc326c5b4857001a9aaef8a8e0924b2ecd6b57a42b00a4abebda3b6a575c72c96581b5ab60ab42ba02d0a074d5eff7fbfd7eb065a476c525975c66ae5da986857405a089e9aabf2f345df1b1c125975c66ae5d85062cd21580094f577d0db52b2eb9e4b2f0da55306091ae0050bbe263834b2eb9cc55bbf25a28d21580a6a42bc65d71c92597e5d5ae7cd18a7405a029e94afd96da15975c72596ced2a18ad4857001a94ae425b466a575c72c9659ef9aea28ee54857009a92ae98ef8a4b2eb92cb076c56ca2004857ccd5ce25975c32573b00644a577d63d4aeb8e4924bf3cbb46d0be90ac084a4abb4f8c0e0924b2e4d2ed3b62da42b00354d57ad6d77ebc8d16357af3c262217d72f9f983f2e00504f5e6ba61a34c771363636d82d004a75f5ca637a94721ce780feeb5eafc73e020000c8e3c0f53ffe0d7b040000208f1bd80500000005baae76b5b4747f19f7d1ebf55455aca4ed4f12f615fb8a7d95fb997e9b571c8045e94a447abdb794dcf6bd859dcebe625fb1af006082d13308000040ba020000205dd55dab75a8e14fbfe17b000080094957393fd15526f0fe99dc4bfe0c311929c4b74f46a39dd16827660f5b1e07437f0c5d12f56650d783ef28dff5a8db266e39ea56313f667eeb9adc7bcef773b607030093e1c0c43fc3d04c10d3d0a75abfe11f15faeecabfebc6feb00d9f8bef57a3d14e70fda8bba8d15eaaecefae213b0440a3d4ac6730b1c050d487ae445765e2efaea61f15a1fb537ffa75ec1954b9273edf78eb84de30740b794267e8ddc56cc4b77ef0e6d91ea1f91f5ad43b41ff31f44accfa315ba0031ac064a85fed2a6d19c06bace3570e46ab06d61b629262e81ed03fec9bb38b7c7127fe8d149ffc422f2bcb9d51f71e7c18a1ef04f367ea5b3fb1aad7d8bf3800a42b4b4340ccaf8a6ab21bdeeeeb71cafe4fc4fc9125b885f13ecdd0c753f8ce8fd960d4d8aca887c1002c00a4abe6aab27230a9591645bd91829d6b55ee76af82157cb97d793a554a4b5c9fb716808931093332187e1930717dc331311c61d73a0efa5ee5a8724bfe7257e2dde9392cb422e5fdcbf646354f81a189d0700f246ea7d8bf6800a8851ad4aef28cec493b30c8fb78c83ca2a88c21c6d54490a8e1d2f11daf751c7715f5b00b7cc58399a3467bc9f768f57742da6067be7e33c7f001205dd95278085e8f6f8b530dbc8dd96c8177578b5d6df894ad7dbe314f27f1b7996f68723ded6df59463f277916d17657b8e267f3e897fc2867f590050238d9bab9dc1550000a0548d1bd54eb4029ae3fccab9ab571e633f00a8586bdbdd3a72f4986a808e1c3d56da1dfd8d8888fc187b9c7dc5be625f95ca8b536536680010def85c5cbfec38ce81d056a934df66efb3afd857ecab8a63160054ec06760100004081aeab5d5d5cbfcc1e01000048a5d7ebe9f572ffa8f613f3c7d94700000099d13308000040ba020000205d0100004c1e6f662bd21500004001d16a6969c9b790740500005058b4225d010000e48a56c1f9164857000000d9a355f0bc5ba42b000080ecd18a715700000025462bd215000040ae68c5b82b00008022a315e3ae0000008a8c568cbb02000028315a91ae0000007245abe0b8abd6b6bbe59d1f27d871080000d064be7308c6bbb87ed9719c03996f0f000080207a060100008a744044420764010000208356b7db652f00000014e5ff03e1da621b6c7b2bdc0000000049454e44ae426082);
INSERT INTO `img` (`img_id`, `slug`, `img`) VALUES(6, '11', 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);
INSERT INTO `img` (`img_id`, `slug`, `img`) VALUES(7, '12-duze', 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);
INSERT INTO `img` (`img_id`, `slug`, `img`) VALUES(8, '12', 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);
INSERT INTO `img` (`img_id`, `slug`, `img`) VALUES(9, '13-duze', 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);
INSERT INTO `img` (`img_id`, `slug`, `img`) VALUES(10, '13', 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);
INSERT INTO `img` (`img_id`, `slug`, `img`) VALUES(11, '14-duze', 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);
INSERT INTO `img` (`img_id`, `slug`, `img`) VALUES(12, '14', 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);
INSERT INTO `img` (`img_id`, `slug`, `img`) VALUES(13, '15-duze', 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);
INSERT INTO `img` (`img_id`, `slug`, `img`) VALUES(14, '15', 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);
INSERT INTO `img` (`img_id`, `slug`, `img`) VALUES(15, '16-duze', 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);
INSERT INTO `img` (`img_id`, `slug`, `img`) VALUES(16, '16', 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);
INSERT INTO `img` (`img_id`, `slug`, `img`) VALUES(17, '17-duze', 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);
INSERT INTO `img` (`img_id`, `slug`, `img`) VALUES(18, '17', 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);
INSERT INTO `img` (`img_id`, `slug`, `img`) VALUES(19, '2-duze', 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);
INSERT INTO `img` (`img_id`, `slug`, `img`) VALUES(20, '2', 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);
INSERT INTO `img` (`img_id`, `slug`, `img`) VALUES(21, '3-duze', 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);
INSERT INTO `img` (`img_id`, `slug`, `img`) VALUES(22, '3', 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);
INSERT INTO `img` (`img_id`, `slug`, `img`) VALUES(23, '4-duze', 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);
INSERT INTO `img` (`img_id`, `slug`, `img`) VALUES(24, '4', 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);
INSERT INTO `img` (`img_id`, `slug`, `img`) VALUES(25, '5-duze', 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);
INSERT INTO `img` (`img_id`, `slug`, `img`) VALUES(26, '5', 0x89504e470d0a1a0a0000000d49484452000001900000018d0802000000b095b0de000000097048597300000b1300000b1301009a9c180000000774494d4507d707100a31161ec83a8d000020004944415478daecbd7b742457752fbc4fbdfbfdee56abd57a8e34d268a4797a6c06924b80000192ac04966d20907c04c80d591056e0bb097c973f4216c15e042f932ce210620c2101e7c664d95c5e49000386c1af196b466f8ddeea563fd4efaeae77d5f9fea8514fabbbf5187b6ccf8cebb7349a52d5a95355a7cef9d5defbecb3372a97f214c580050b162cdcc0d0756d6a6a86a22846d735c3d0ad16b160c1c20d0b55d52459a600c030f4a9854ca9220300c60660ada1184204ddee748450dbdd3b7fed3cd4bc1f35fd7f75b3b9f29d7fa336176d28d1b28576bd2202d4f621da3c41435d68dffd68f71b6d7d3ad4e6811b6f051de8fe766b4fd4fe39dabfa73d6e05b57f56b47bcd57afb0eb1decd66e68f7c27bdc2bdab3f1db3f5cfbb6dca367eede9fd00147c96e4fd7dc54a8e94268d7b1d676ccb41f8e68ef3182767bdfbb3c063a58377ec12041a30d190028f3ef6245cee66a0040409173113442d83074822035a354d1082ad8d42868b7d187da7482b624d6be06b45bfba336edba7320b4b99de626dd594bcb3d22d47e88a2dd7a602beda1367fb65e603f8e436d0fa2d66edadc4668df2f07427bd0356aad1cb51fc6a87d1da8cdbb683b02d16e430db57dddeda8b7e5d9106040bbbf952b17c52d0f8bdbb30bda8d43d05e6485f6a36984da92c47e2f17b5f94eb4e7985d4750739740fb316cbd1486f6ef103534a7790043c04112ed58ab542ab12c6bb3d95a0fd56ab522af067c1e1bd39eef96d7370381802937518d07b02139bb7c8eae4e300cdae9a41c0e3e91e84f675633d781236351afdbc9952a622a5bbe5ebccb325477a7fff26a761f7a268881d