<?php

require_once 'walidacja.inc.php';
require_once 'slugs.inc.php';

/*
 * Moe by:
 *     dane/
 *     dane
 */
function podaj_foldery_kategorii($AFolder)
{
    $folder_danych = rtrim($AFolder, '/');
    $flds = glob($folder_danych . '/*');
    sort($flds);
    $krotkie = array_map('basename', $flds);    
    
    $kompletne = array();
    foreach ($flds as $k=>$v) {
        $kompletne[$k] = $v . '/';
    }
    
    $result = array(
        'count' => count($flds), 
        'short' => $krotkie,
        'long' => $kompletne
    );
    
    return $result;
}


function parsuj_foldery_kategorii($AFolder, $ACzyTworzycVH = false)
{
    $flds = podaj_foldery_kategorii($AFolder);
    
    $flds['caption'] = array();
    $flds['newfoldername'] = array();
    $flds['images_short'] = array();    
    $flds['images_long'] = array();        
    $flds['images_count'] = array();        

    for ($i = 0; $i < $flds['count']; $i++) {
    
        $np = $flds['long'][$i] . 'info.txt';
        if (file_exists($np)) {

            $tmp = file($np);
            $tmp_caption = trim($tmp[0]);
            if ($tmp_caption == '') {
                die('----parsuj_foldery_kategorii #1----');
            }
            $flds['caption'][$i] = $tmp_caption;
        
            $tmp_newfoldername = '';
            if (!(isset($tmp[1]) && ($tmp_newfoldername = trim($tmp[1])))) {
                $tmp_newfoldername = string2slug($tmp_caption);
            }
        
            $flds['newfoldername'][$i] = $tmp_newfoldername;
        } else {
            $flds['caption'][$i] = ucfirst($flds['short'][$i]);
            $flds['newfoldername'][$i] = $flds['short'][$i];
        }
        
        $obrazy_kategorii = glob($flds['long'][$i] . '*.jpg');
        $liczba_obrazow_kategorii = count($obrazy_kategorii);
        
        $flds['images_long'][$i] = $obrazy_kategorii;                
        $flds['images_count'][$i] = $liczba_obrazow_kategorii;        
        
        for ($j = 0; $j < $liczba_obrazow_kategorii; $j++) {
            $obrazy_kategorii[$j] = basename($obrazy_kategorii[$j]);
        }

        $flds['images_short'][$i] = $obrazy_kategorii;
        
    }
    
    return $flds;

}

function ustal_domyslne_opcje(&$konf)
{

    if (!(isset($konf['mini-szerokosc']) && (str_ievpi($konf['mini-szerokosc'])))) {
        $konf['mini-szerokosc'] = '133';
    }
    
    if (!(isset($konf['mini-wysokosc']) && (str_ievpi($konf['mini-wysokosc'])))) {
        $konf['mini-wysokosc'] = '100';
    }
     
    if (!(isset($konf['mini-jakosc']) && (str_ievpi($konf['mini-jakosc'])))) {
        $konf['mini-jakosc'] = '85';
    }
    
    if (!(isset($konf['preview-szerokosc']) && (str_ievpi($konf['preview-szerokosc'])))) {
        $konf['preview-szerokosc'] = '600';
    }
    
    if (!(isset($konf['preview-wysokosc']) && (str_ievpi($konf['preview-wysokosc'])))) {
        $konf['preview-wysokosc'] = '400';
    }
     
    if (!(isset($konf['preview-jakosc']) && (str_ievpi($konf['preview-jakosc'])))) {
        $konf['preview-jakosc'] = '80';
    }
    
    
    if (!(isset($konf['popup-szerokosc']) && (str_ievpi($konf['popup-szerokosc'])))) {
        $konf['popup-szerokosc'] = '450';
    }
    
    if (!(isset($konf['popup-wysokosc']) && (str_ievpi($konf['popup-wysokosc'])))) {
        $konf['popup-wysokosc'] = '300';
    }
     
    if (!(isset($konf['popup-jakosc']) && (str_ievpi($konf['popup-jakosc'])))) {
        $konf['popup-jakosc'] = '90';
    }
    
    if (!isset($konf['znakiwodne'])) {
        $konf['znakiwodne'] = false;
    }

}

function podaj_numer_plyty($folder)
{
    $re = '/^dane\/dvd-([0-9]+)$/';
    if (preg_match($re, $folder, $m)) {
        return $m[1];
    } else {
        return false;
    }
}


function przetworz_folder($konfiguracja, $folder)
{
    ob_flush();
    flush();
    echo $folder . "\n";
    

    /*
     * ETAP I
     * Usuwamy pyt jeli istnieje
     *
     */
    $numer_plyty = podaj_numer_plyty($folder);
    DvdPeer::usun($numer_plyty);


    /*
     * ETAP II
     * Wstawiamy pyt
     *
     */
    $data_wydania = trim(file_get_contents($folder . '/datawydania.txt'));
    $okladka = file_get_contents($folder . '/dvd-' . $numer_plyty . '.png');
    $druk = file_get_contents($folder . '/dvd-' . $numer_plyty . '-wydruk.png');
    
    if (file_exists($folder . '/wydanie.txt')) {
        $wydanie = trim(file_get_contents($folder . '/wydanie.txt'));
    } else {
        $wydanie = 'pierwsze';
    }
    
    $dane_dvd = array(
        'numer'         => $numer_plyty,
        'datawydania'   => $data_wydania,
        'wydanie'       => $wydanie,
        'okladka'       => $okladka,
        'okladka_print' => $druk
    );
    
    $dvd = DvdPeer::wstaw($dane_dvd);
    
    
    if ($konfiguracja['znakiwodne']) {
        $watermark = ImageCreateFromPNG('watermark.png');
    }

    
    /*
     * ETAP III
     * Przetwarzamy kategorie pyty
     *
     */
    $flds = parsuj_foldery_kategorii($folder . '/fotki');
    for ($i = 0; $i < $flds['count']; $i++) {
    
        $dane_kategorii = array(
            'dvd_id'      => $dvd->getDvdId(),
            'nazwa'       => $flds['caption'][$i],
            'slug'        => $flds['newfoldername'][$i],
            'liczbafotek' => $flds['images_count'][$i]
        );

        $kategoria = KategoriaPeer::wstaw($dane_kategorii);
    
        /*
         * Wstawiamy fotki kategorii
         *
         */
        for ($j = 0; $j < $flds['images_count'][$i]; $j++) {
        

            if ($konfiguracja['znakiwodne']) {
            
                $tmp_img = ImageCreateFromJPEG($flds['images_long'][$i][$j]);
                $tmp_img = gd_watermark_obj($tmp_img, $watermark);

                ob_start();
                imagejpeg($tmp_img, NULL, 95);
                $obraz = ob_get_clean();

                
            } else {
            
                $obraz = file_get_contents($flds['images_long'][$i][$j]);

            }

            $dane_fotki = array(
                'kategoria_id' => $kategoria->getKategoriaId(),
                'max' => $obraz,
                'slug' => $j + 1
            );
            
            FotkaPeer::wstaw($dane_fotki);
            
        }    
    
    }
    
}