<?php

/**
 * Base class that represents a row from the 'fotka' table.
 *
 * 
 *
 * @package    sklep.om
 */
abstract class BaseFotka extends BaseObject  implements Persistent {


	/**
	 * The Peer class.
	 * Instance provides a convenient way of calling static methods on a class
	 * that calling code may not be able to identify.
	 * @var        FotkaPeer
	 */
	protected static $peer;

	/**
	 * The value for the fotka_id field.
	 * @var        int
	 */
	protected $fotka_id;

	/**
	 * The value for the max field.
	 * @var        resource
	 */
	protected $max;

	/**
	 * The value for the preview field.
	 * @var        resource
	 */
	protected $preview;

	/**
	 * The value for the popup field.
	 * @var        resource
	 */
	protected $popup;

	/**
	 * The value for the mini field.
	 * @var        resource
	 */
	protected $mini;

	/**
	 * The value for the slug field.
	 * @var        int
	 */
	protected $slug;

	/**
	 * The value for the kategoria_id field.
	 * @var        int
	 */
	protected $kategoria_id;

	/**
	 * @var        Kategoria
	 */
	protected $aKategoria;

	/**
	 * Flag to prevent endless save loop, if this object is referenced
	 * by another object which falls in this transaction.
	 * @var        boolean
	 */
	protected $alreadyInSave = false;

	/**
	 * Flag to prevent endless validation loop, if this object is referenced
	 * by another object which falls in this transaction.
	 * @var        boolean
	 */
	protected $alreadyInValidation = false;

	/**
	 * Initializes internal state of BaseFotka object.
	 * @see        applyDefaults()
	 */
	public function __construct()
	{
		parent::__construct();
		$this->applyDefaultValues();
	}

	/**
	 * Applies default values to this object.
	 * This method should be called from the object's constructor (or
	 * equivalent initialization method).
	 * @see        __construct()
	 */
	public function applyDefaultValues()
	{
	}

	/**
	 * Get the [fotka_id] column value.
	 * 
	 * @return     int
	 */
	public function getFotkaId()
	{
		return $this->fotka_id;
	}

	/**
	 * Get the [max] column value.
	 * 
	 * @return     resource
	 */
	public function getMax()
	{
		return $this->max;
	}

	/**
	 * Get the [preview] column value.
	 * 
	 * @return     resource
	 */
	public function getPreview()
	{
		return $this->preview;
	}

	/**
	 * Get the [popup] column value.
	 * 
	 * @return     resource
	 */
	public function getPopup()
	{
		return $this->popup;
	}

	/**
	 * Get the [mini] column value.
	 * 
	 * @return     resource
	 */
	public function getMini()
	{
		return $this->mini;
	}

	/**
	 * Get the [slug] column value.
	 * 
	 * @return     int
	 */
	public function getSlug()
	{
		return $this->slug;
	}

	/**
	 * Get the [kategoria_id] column value.
	 * 
	 * @return     int
	 */
	public function getKategoriaId()
	{
		return $this->kategoria_id;
	}

	/**
	 * Set the value of [fotka_id] column.
	 * 
	 * @param      int $v new value
	 * @return     Fotka The current object (for fluent API support)
	 */
	public function setFotkaId($v)
	{
		if ($v !== null) {
			$v = (int) $v;
		}

		if ($this->fotka_id !== $v) {
			$this->fotka_id = $v;
			$this->modifiedColumns[] = FotkaPeer::FOTKA_ID;
		}

		return $this;
	} // setFotkaId()

	/**
	 * Set the value of [max] column.
	 * 
	 * @param      resource $v new value
	 * @return     Fotka The current object (for fluent API support)
	 */
	public function setMax($v)
	{
		// Because BLOB columns are streams in PDO we have to assume that they are
		// always modified when a new value is passed in.  For example, the contents
		// of the stream itself may have changed externally.
		if (!is_resource($v)) {
			$this->max = fopen('php://memory', 'r+');
			fwrite($this->max, $v);
			rewind($this->max);
		} else { // it's already a stream
			$this->max = $v;
		}
		$this->modifiedColumns[] = FotkaPeer::MAX;

		return $this;
	} // setMax()

	/**
	 * Set the value of [preview] column.
	 * 
	 * @param      resource $v new value
	 * @return     Fotka The current object (for fluent API support)
	 */
	public function setPreview($v)
	{
		// Because BLOB columns are streams in PDO we have to assume that they are
		// always modified when a new value is passed in.  For example, the contents
		// of the stream itself may have changed externally.
		if (!is_resource($v)) {
			$this->preview = fopen('php://memory', 'r+');
			fwrite($this->preview, $v);
			rewind($this->preview);
		} else { // it's already a stream
			$this->preview = $v;
		}
		$this->modifiedColumns[] = FotkaPeer::PREVIEW;

		return $this;
	} // setPreview()

	/**
	 * Set the value of [popup] column.
	 * 
	 * @param      resource $v new value
	 * @return     Fotka The current object (for fluent API support)
	 */
	public function setPopup($v)
	{
		// Because BLOB columns are streams in PDO we have to assume that they are
		// always modified when a new value is passed in.  For example, the contents
		// of the stream itself may have changed externally.
		if (!is_resource($v)) {
			$this->popup = fopen('php://memory', 'r+');
			fwrite($this->popup, $v);
			rewind($this->popup);
		} else { // it's already a stream
			$this->popup = $v;
		}
		$this->modifiedColumns[] = FotkaPeer::POPUP;

		return $this;
	} // setPopup()

	/**
	 * Set the value of [mini] column.
	 * 
	 * @param      resource $v new value
	 * @return     Fotka The current object (for fluent API support)
	 */
	public function setMini($v)
	{
		// Because BLOB columns are streams in PDO we have to assume that they are
		// always modified when a new value is passed in.  For example, the contents
		// of the stream itself may have changed externally.
		if (!is_resource($v)) {
			$this->mini = fopen('php://memory', 'r+');
			fwrite($this->mini, $v);
			rewind($this->mini);
		} else { // it's already a stream
			$this->mini = $v;
		}
		$this->modifiedColumns[] = FotkaPeer::MINI;

		return $this;
	} // setMini()

	/**
	 * Set the value of [slug] column.
	 * 
	 * @param      int $v new value
	 * @return     Fotka The current object (for fluent API support)
	 */
	public function setSlug($v)
	{
		if ($v !== null) {
			$v = (int) $v;
		}

		if ($this->slug !== $v) {
			$this->slug = $v;
			$this->modifiedColumns[] = FotkaPeer::SLUG;
		}

		return $this;
	} // setSlug()

	/**
	 * Set the value of [kategoria_id] column.
	 * 
	 * @param      int $v new value
	 * @return     Fotka The current object (for fluent API support)
	 */
	public function setKategoriaId($v)
	{
		if ($v !== null) {
			$v = (int) $v;
		}

		if ($this->kategoria_id !== $v) {
			$this->kategoria_id = $v;
			$this->modifiedColumns[] = FotkaPeer::KATEGORIA_ID;
		}

		if ($this->aKategoria !== null && $this->aKategoria->getKategoriaId() !== $v) {
			$this->aKategoria = null;
		}

		return $this;
	} // setKategoriaId()

	/**
	 * Indicates whether the columns in this object are only set to default values.
	 *
	 * This method can be used in conjunction with isModified() to indicate whether an object is both
	 * modified _and_ has some values set which are non-default.
	 *
	 * @return     boolean Whether the columns in this object are only been set with default values.
	 */
	public function hasOnlyDefaultValues()
	{
			// First, ensure that we don't have any columns that have been modified which aren't default columns.
			if (array_diff($this->modifiedColumns, array())) {
				return false;
			}

		// otherwise, everything was equal, so return TRUE
		return true;
	} // hasOnlyDefaultValues()

	/**
	 * Hydrates (populates) the object variables with values from the database resultset.
	 *
	 * An offset (0-based "start column") is specified so that objects can be hydrated
	 * with a subset of the columns in the resultset rows.  This is needed, for example,
	 * for results of JOIN queries where the resultset row includes columns from two or
	 * more tables.
	 *
	 * @param      array $row The row returned by PDOStatement->fetch(PDO::FETCH_NUM)
	 * @param      int $startcol 0-based offset column which indicates which restultset column to start with.
	 * @param      boolean $rehydrate Whether this object is being re-hydrated from the database.
	 * @return     int next starting column
	 * @throws     PropelException  - Any caught Exception will be rewrapped as a PropelException.
	 */
	public function hydrate($row, $startcol = 0, $rehydrate = false)
	{
		try {

			$this->fotka_id = ($row[$startcol + 0] !== null) ? (int) $row[$startcol + 0] : null;
			if ($row[$startcol + 1] !== null) {
				$this->max = fopen('php://memory', 'r+');
				fwrite($this->max, $row[$startcol + 1]);
				rewind($this->max);
			} else {
				$this->max = null;
			}
			if ($row[$startcol + 2] !== null) {
				$this->preview = fopen('php://memory', 'r+');
				fwrite($this->preview, $row[$startcol + 2]);
				rewind($this->preview);
			} else {
				$this->preview = null;
			}
			if ($row[$startcol + 3] !== null) {
				$this->popup = fopen('php://memory', 'r+');
				fwrite($this->popup, $row[$startcol + 3]);
				rewind($this->popup);
			} else {
				$this->popup = null;
			}
			if ($row[$startcol + 4] !== null) {
				$this->mini = fopen('php://memory', 'r+');
				fwrite($this->mini, $row[$startcol + 4]);
				rewind($this->mini);
			} else {
				$this->mini = null;
			}
			$this->slug = ($row[$startcol + 5] !== null) ? (int) $row[$startcol + 5] : null;
			$this->kategoria_id = ($row[$startcol + 6] !== null) ? (int) $row[$startcol + 6] : null;
			$this->resetModified();

			$this->setNew(false);

			if ($rehydrate) {
				$this->ensureConsistency();
			}

			// FIXME - using NUM_COLUMNS may be clearer.
			return $startcol + 7; // 7 = FotkaPeer::NUM_COLUMNS - FotkaPeer::NUM_LAZY_LOAD_COLUMNS).

		} catch (Exception $e) {
			throw new PropelException("Error populating Fotka object", $e);
		}
	}

	/**
	 * Checks and repairs the internal consistency of the object.
	 *
	 * This method is executed after an already-instantiated object is re-hydrated
	 * from the database.  It exists to check any foreign keys to make sure that
	 * the objects related to the current object are correct based on foreign key.
	 *
	 * You can override this method in the stub class, but you should always invoke
	 * the base method from the overridden method (i.e. parent::ensureConsistency()),
	 * in case your model changes.
	 *
	 * @throws     PropelException
	 */
	public function ensureConsistency()
	{

		if ($this->aKategoria !== null && $this->kategoria_id !== $this->aKategoria->getKategoriaId()) {
			$this->aKategoria = null;
		}
	} // ensureConsistency

	/**
	 * Reloads this object from datastore based on primary key and (optionally) resets all associated objects.
	 *
	 * This will only work if the object has been saved and has a valid primary key set.
	 *
	 * @param      boolean $deep (optional) Whether to also de-associated any related objects.
	 * @param      PropelPDO $con (optional) The PropelPDO connection to use.
	 * @return     void
	 * @throws     PropelException - if this object is deleted, unsaved or doesn't have pk match in db
	 */
	public function reload($deep = false, PropelPDO $con = null)
	{
		if ($this->isDeleted()) {
			throw new PropelException("Cannot reload a deleted object.");
		}

		if ($this->isNew()) {
			throw new PropelException("Cannot reload an unsaved object.");
		}

		if ($con === null) {
			$con = Propel::getConnection(FotkaPeer::DATABASE_NAME, Propel::CONNECTION_READ);
		}

		// We don't need to alter the object instance pool; we're just modifying this instance
		// already in the pool.

		$stmt = FotkaPeer::doSelectStmt($this->buildPkeyCriteria(), $con);
		$row = $stmt->fetch(PDO::FETCH_NUM);
		$stmt->closeCursor();
		if (!$row) {
			throw new PropelException('Cannot find matching row in the database to reload object values.');
		}
		$this->hydrate($row, 0, true); // rehydrate

		if ($deep) {  // also de-associate any related objects?

			$this->aKategoria = null;
		} // if (deep)
	}

	/**
	 * Removes this object from datastore and sets delete attribute.
	 *
	 * @param      PropelPDO $con
	 * @return     void
	 * @throws     PropelException
	 * @see        BaseObject::setDeleted()
	 * @see        BaseObject::isDeleted()
	 */
	public function delete(PropelPDO $con = null)
	{
		if ($this->isDeleted()) {
			throw new PropelException("This object has already been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(FotkaPeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
		}
		
		$con->beginTransaction();
		try {
			FotkaPeer::doDelete($this, $con);
			$this->setDeleted(true);
			$con->commit();
		} catch (PropelException $e) {
			$con->rollBack();
			throw $e;
		}
	}

	/**
	 * Persists this object to the database.
	 *
	 * If the object is new, it inserts it; otherwise an update is performed.
	 * All modified related objects will also be persisted in the doSave()
	 * method.  This method wraps all precipitate database operations in a
	 * single transaction.
	 *
	 * @param      PropelPDO $con
	 * @return     int The number of rows affected by this insert/update and any referring fk objects' save() operations.
	 * @throws     PropelException
	 * @see        doSave()
	 */
	public function save(PropelPDO $con = null)
	{
		if ($this->isDeleted()) {
			throw new PropelException("You cannot save an object that has been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(FotkaPeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
		}
		
		$con->beginTransaction();
		try {
			$affectedRows = $this->doSave($con);
			$con->commit();
			FotkaPeer::addInstanceToPool($this);
			return $affectedRows;
		} catch (PropelException $e) {
			$con->rollBack();
			throw $e;
		}
	}

	/**
	 * Performs the work of inserting or updating the row in the database.
	 *
	 * If the object is new, it inserts it; otherwise an update is performed.
	 * All related objects are also updated in this method.
	 *
	 * @param      PropelPDO $con
	 * @return     int The number of rows affected by this insert/update and any referring fk objects' save() operations.
	 * @throws     PropelException
	 * @see        save()
	 */
	protected function doSave(PropelPDO $con)
	{
		$affectedRows = 0; // initialize var to track total num of affected rows
		if (!$this->alreadyInSave) {
			$this->alreadyInSave = true;

			// We call the save method on the following object(s) if they
			// were passed to this object by their coresponding set
			// method.  This object relates to these object(s) by a
			// foreign key reference.

			if ($this->aKategoria !== null) {
				if ($this->aKategoria->isModified() || $this->aKategoria->isNew()) {
					$affectedRows += $this->aKategoria->save($con);
				}
				$this->setKategoria($this->aKategoria);
			}

			if ($this->isNew() ) {
				$this->modifiedColumns[] = FotkaPeer::FOTKA_ID;
			}

			// If this object has been modified, then save it to the database.
			if ($this->isModified()) {
				if ($this->isNew()) {
					$pk = FotkaPeer::doInsert($this, $con);
					$affectedRows += 1; // we are assuming that there is only 1 row per doInsert() which
										 // should always be true here (even though technically
										 // BasePeer::doInsert() can insert multiple rows).

					$this->setFotkaId($pk);  //[IMV] update autoincrement primary key

					$this->setNew(false);
				} else {
					$affectedRows += FotkaPeer::doUpdate($this, $con);
				}

				// Rewind the max LOB column, since PDO does not rewind after inserting value.
				if ($this->max !== null && is_resource($this->max)) {
					rewind($this->max);
				}

				// Rewind the preview LOB column, since PDO does not rewind after inserting value.
				if ($this->preview !== null && is_resource($this->preview)) {
					rewind($this->preview);
				}

				// Rewind the popup LOB column, since PDO does not rewind after inserting value.
				if ($this->popup !== null && is_resource($this->popup)) {
					rewind($this->popup);
				}

				// Rewind the mini LOB column, since PDO does not rewind after inserting value.
				if ($this->mini !== null && is_resource($this->mini)) {
					rewind($this->mini);
				}

				$this->resetModified(); // [HL] After being saved an object is no longer 'modified'
			}

			$this->alreadyInSave = false;

		}
		return $affectedRows;
	} // doSave()

	/**
	 * Array of ValidationFailed objects.
	 * @var        array ValidationFailed[]
	 */
	protected $validationFailures = array();

	/**
	 * Gets any ValidationFailed objects that resulted from last call to validate().
	 *
	 *
	 * @return     array ValidationFailed[]
	 * @see        validate()
	 */
	public function getValidationFailures()
	{
		return $this->validationFailures;
	}

	/**
	 * Validates the objects modified field values and all objects related to this table.
	 *
	 * If $columns is either a column name or an array of column names
	 * only those columns are validated.
	 *
	 * @param      mixed $columns Column name or an array of column names.
	 * @return     boolean Whether all columns pass validation.
	 * @see        doValidate()
	 * @see        getValidationFailures()
	 */
	public function validate($columns = null)
	{
		$res = $this->doValidate($columns);
		if ($res === true) {
			$this->validationFailures = array();
			return true;
		} else {
			$this->validationFailures = $res;
			return false;
		}
	}

	/**
	 * This function performs the validation work for complex object models.
	 *
	 * In addition to checking the current object, all related objects will
	 * also be validated.  If all pass then <code>true</code> is returned; otherwise
	 * an aggreagated array of ValidationFailed objects will be returned.
	 *
	 * @param      array $columns Array of column names to validate.
	 * @return     mixed <code>true</code> if all validations pass; array of <code>ValidationFailed</code> objets otherwise.
	 */
	protected function doValidate($columns = null)
	{
		if (!$this->alreadyInValidation) {
			$this->alreadyInValidation = true;
			$retval = null;

			$failureMap = array();


			// We call the validate method on the following object(s) if they
			// were passed to this object by their coresponding set
			// method.  This object relates to these object(s) by a
			// foreign key reference.

			if ($this->aKategoria !== null) {
				if (!$this->aKategoria->validate($columns)) {
					$failureMap = array_merge($failureMap, $this->aKategoria->getValidationFailures());
				}
			}


			if (($retval = FotkaPeer::doValidate($this, $columns)) !== true) {
				$failureMap = array_merge($failureMap, $retval);
			}



			$this->alreadyInValidation = false;
		}

		return (!empty($failureMap) ? $failureMap : true);
	}

	/**
	 * Retrieves a field from the object by name passed in as a string.
	 *
	 * @param      string $name name
	 * @param      string $type The type of fieldname the $name is of:
	 *                     one of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME
	 *                     BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM
	 * @return     mixed Value of field.
	 */
	public function getByName($name, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = FotkaPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		$field = $this->getByPosition($pos);
		return $field;
	}

	/**
	 * Retrieves a field from the object by Position as specified in the xml schema.
	 * Zero-based.
	 *
	 * @param      int $pos position in xml schema
	 * @return     mixed Value of field at $pos
	 */
	public function getByPosition($pos)
	{
		switch($pos) {
			case 0:
				return $this->getFotkaId();
				break;
			case 1:
				return $this->getMax();
				break;
			case 2:
				return $this->getPreview();
				break;
			case 3:
				return $this->getPopup();
				break;
			case 4:
				return $this->getMini();
				break;
			case 5:
				return $this->getSlug();
				break;
			case 6:
				return $this->getKategoriaId();
				break;
			default:
				return null;
				break;
		} // switch()
	}

	/**
	 * Exports the object as an array.
	 *
	 * You can specify the key type of the array by passing one of the class
	 * type constants.
	 *
	 * @param      string $keyType (optional) One of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME
	 *                        BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM. Defaults to BasePeer::TYPE_PHPNAME.
	 * @param      boolean $includeLazyLoadColumns (optional) Whether to include lazy loaded columns.  Defaults to TRUE.
	 * @return     an associative array containing the field names (as keys) and field values
	 */
	public function toArray($keyType = BasePeer::TYPE_PHPNAME, $includeLazyLoadColumns = true)
	{
		$keys = FotkaPeer::getFieldNames($keyType);
		$result = array(
			$keys[0] => $this->getFotkaId(),
			$keys[1] => $this->getMax(),
			$keys[2] => $this->getPreview(),
			$keys[3] => $this->getPopup(),
			$keys[4] => $this->getMini(),
			$keys[5] => $this->getSlug(),
			$keys[6] => $this->getKategoriaId(),
		);
		return $result;
	}

	/**
	 * Sets a field from the object by name passed in as a string.
	 *
	 * @param      string $name peer name
	 * @param      mixed $value field value
	 * @param      string $type The type of fieldname the $name is of:
	 *                     one of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME
	 *                     BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM
	 * @return     void
	 */
	public function setByName($name, $value, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = FotkaPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->setByPosition($pos, $value);
	}

	/**
	 * Sets a field from the object by Position as specified in the xml schema.
	 * Zero-based.
	 *
	 * @param      int $pos position in xml schema
	 * @param      mixed $value field value
	 * @return     void
	 */
	public function setByPosition($pos, $value)
	{
		switch($pos) {
			case 0:
				$this->setFotkaId($value);
				break;
			case 1:
				$this->setMax($value);
				break;
			case 2:
				$this->setPreview($value);
				break;
			case 3:
				$this->setPopup($value);
				break;
			case 4:
				$this->setMini($value);
				break;
			case 5:
				$this->setSlug($value);
				break;
			case 6:
				$this->setKategoriaId($value);
				break;
		} // switch()
	}

	/**
	 * Populates the object using an array.
	 *
	 * This is particularly useful when populating an object from one of the
	 * request arrays (e.g. $_POST).  This method goes through the column
	 * names, checking to see whether a matching key exists in populated
	 * array. If so the setByName() method is called for that column.
	 *
	 * You can specify the key type of the array by additionally passing one
	 * of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME,
	 * BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM.
	 * The default key type is the column's phpname (e.g. 'AuthorId')
	 *
	 * @param      array  $arr     An array to populate the object from.
	 * @param      string $keyType The type of keys the array uses.
	 * @return     void
	 */
	public function fromArray($arr, $keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = FotkaPeer::getFieldNames($keyType);

		if (array_key_exists($keys[0], $arr)) $this->setFotkaId($arr[$keys[0]]);
		if (array_key_exists($keys[1], $arr)) $this->setMax($arr[$keys[1]]);
		if (array_key_exists($keys[2], $arr)) $this->setPreview($arr[$keys[2]]);
		if (array_key_exists($keys[3], $arr)) $this->setPopup($arr[$keys[3]]);
		if (array_key_exists($keys[4], $arr)) $this->setMini($arr[$keys[4]]);
		if (array_key_exists($keys[5], $arr)) $this->setSlug($arr[$keys[5]]);
		if (array_key_exists($keys[6], $arr)) $this->setKategoriaId($arr[$keys[6]]);
	}

	/**
	 * Build a Criteria object containing the values of all modified columns in this object.
	 *
	 * @return     Criteria The Criteria object containing all modified values.
	 */
	public function buildCriteria()
	{
		$criteria = new Criteria(FotkaPeer::DATABASE_NAME);

		if ($this->isColumnModified(FotkaPeer::FOTKA_ID)) $criteria->add(FotkaPeer::FOTKA_ID, $this->fotka_id);
		if ($this->isColumnModified(FotkaPeer::MAX)) $criteria->add(FotkaPeer::MAX, $this->max);
		if ($this->isColumnModified(FotkaPeer::PREVIEW)) $criteria->add(FotkaPeer::PREVIEW, $this->preview);
		if ($this->isColumnModified(FotkaPeer::POPUP)) $criteria->add(FotkaPeer::POPUP, $this->popup);
		if ($this->isColumnModified(FotkaPeer::MINI)) $criteria->add(FotkaPeer::MINI, $this->mini);
		if ($this->isColumnModified(FotkaPeer::SLUG)) $criteria->add(FotkaPeer::SLUG, $this->slug);
		if ($this->isColumnModified(FotkaPeer::KATEGORIA_ID)) $criteria->add(FotkaPeer::KATEGORIA_ID, $this->kategoria_id);

		return $criteria;
	}

	/**
	 * Builds a Criteria object containing the primary key for this object.
	 *
	 * Unlike buildCriteria() this method includes the primary key values regardless
	 * of whether or not they have been modified.
	 *
	 * @return     Criteria The Criteria object containing value(s) for primary key(s).
	 */
	public function buildPkeyCriteria()
	{
		$criteria = new Criteria(FotkaPeer::DATABASE_NAME);

		$criteria->add(FotkaPeer::FOTKA_ID, $this->fotka_id);

		return $criteria;
	}

	/**
	 * Returns the primary key for this object (row).
	 * @return     int
	 */
	public function getPrimaryKey()
	{
		return $this->getFotkaId();
	}

	/**
	 * Generic method to set the primary key (fotka_id column).
	 *
	 * @param      int $key Primary key.
	 * @return     void
	 */
	public function setPrimaryKey($key)
	{
		$this->setFotkaId($key);
	}

	/**
	 * Sets contents of passed object to values from current object.
	 *
	 * If desired, this method can also make copies of all associated (fkey referrers)
	 * objects.
	 *
	 * @param      object $copyObj An object of Fotka (or compatible) type.
	 * @param      boolean $deepCopy Whether to also copy all rows that refer (by fkey) to the current row.
	 * @throws     PropelException
	 */
	public function copyInto($copyObj, $deepCopy = false)
	{

		$copyObj->setMax($this->max);

		$copyObj->setPreview($this->preview);

		$copyObj->setPopup($this->popup);

		$copyObj->setMini($this->mini);

		$copyObj->setSlug($this->slug);

		$copyObj->setKategoriaId($this->kategoria_id);


		$copyObj->setNew(true);

		$copyObj->setFotkaId(NULL); // this is a auto-increment column, so set to default value

	}

	/**
	 * Makes a copy of this object that will be inserted as a new row in table when saved.
	 * It creates a new object filling in the simple attributes, but skipping any primary
	 * keys that are defined for the table.
	 *
	 * If desired, this method can also make copies of all associated (fkey referrers)
	 * objects.
	 *
	 * @param      boolean $deepCopy Whether to also copy all rows that refer (by fkey) to the current row.
	 * @return     Fotka Clone of current object.
	 * @throws     PropelException
	 */
	public function copy($deepCopy = false)
	{
		// we use get_class(), because this might be a subclass
		$clazz = get_class($this);
		$copyObj = new $clazz();
		$this->copyInto($copyObj, $deepCopy);
		return $copyObj;
	}

	/**
	 * Returns a peer instance associated with this om.
	 *
	 * Since Peer classes are not to have any instance attributes, this method returns the
	 * same instance for all member of this class. The method could therefore
	 * be static, but this would prevent one from overriding the behavior.
	 *
	 * @return     FotkaPeer
	 */
	public function getPeer()
	{
		if (self::$peer === null) {
			self::$peer = new FotkaPeer();
		}
		return self::$peer;
	}

	/**
	 * Declares an association between this object and a Kategoria object.
	 *
	 * @param      Kategoria $v
	 * @return     Fotka The current object (for fluent API support)
	 * @throws     PropelException
	 */
	public function setKategoria(Kategoria $v = null)
	{
		if ($v === null) {
			$this->setKategoriaId(NULL);
		} else {
			$this->setKategoriaId($v->getKategoriaId());
		}

		$this->aKategoria = $v;

		// Add binding for other direction of this n:n relationship.
		// If this object has already been added to the Kategoria object, it will not be re-added.
		if ($v !== null) {
			$v->addFotka($this);
		}

		return $this;
	}


	/**
	 * Get the associated Kategoria object
	 *
	 * @param      PropelPDO Optional Connection object.
	 * @return     Kategoria The associated Kategoria object.
	 * @throws     PropelException
	 */
	public function getKategoria(PropelPDO $con = null)
	{
		if ($this->aKategoria === null && ($this->kategoria_id !== null)) {
			$this->aKategoria = KategoriaPeer::retrieveByPK($this->kategoria_id, $con);
			/* The following can be used additionally to
			   guarantee the related object contains a reference
			   to this object.  This level of coupling may, however, be
			   undesirable since it could result in an only partially populated collection
			   in the referenced object.
			   $this->aKategoria->addFotkas($this);
			 */
		}
		return $this->aKategoria;
	}

	/**
	 * Resets all collections of referencing foreign keys.
	 *
	 * This method is a user-space workaround for PHP's inability to garbage collect objects
	 * with circular references.  This is currently necessary when using Propel in certain
	 * daemon or large-volumne/high-memory operations.
	 *
	 * @param      boolean $deep Whether to also clear the references on all associated objects.
	 */
	public function clearAllReferences($deep = false)
	{
		if ($deep) {
		} // if ($deep)

			$this->aKategoria = null;
	}

} // BaseFotka
