<?php



class WskaznikKategorii extends Pointer 
{

    function getFirst()
    {
        $c = new Criteria();
        $c->add(KategoriaPeer::DVD_ID, $this->options->getDvdId());
        $c->setLimit(1);                                
        $c->addAscendingOrderByColumn(KategoriaPeer::SLUG);
        if ($tmp = KategoriaPeer::doSelectOne($c)) {
            $this->ptr_first = $tmp;
            if ($this->ptr_current && ($this->ptr_first->getSlug() == $this->ptr_current->getSlug())) {
                $this->ptr_first = false;
            }
        }    
    }
    
    
    function getPrevious()
    {
        if ($this->ptr_current) {
            $c = new Criteria();
            $c->add(KategoriaPeer::DVD_ID, $this->options->getDvdId());
            $c->add(KategoriaPeer::SLUG, $this->ptr_current->getSlug(), Criteria::LESS_THAN);
            $c->setLimit(1);                                
            $c->addDescendingOrderByColumn(KategoriaPeer::SLUG);                        
            if ($tmp = KategoriaPeer::doSelectOne($c)) {
                $this->ptr_previous = $tmp;
            }            
        };    
    }    
    
    function getNext()
    {
        if ($this->ptr_current) {
            $c = new Criteria();
            $c->add(KategoriaPeer::DVD_ID, $this->options->getDvdId());
            $c->add(KategoriaPeer::SLUG, $this->ptr_current->getSlug(), Criteria::GREATER_THAN);
            $c->setLimit(1);          
            $c->addAscendingOrderByColumn(KategoriaPeer::SLUG);		                      
            if ($tmp = KategoriaPeer::doSelectOne($c)) {
                $this->ptr_next = $tmp;
            }            
        }
    }        
    
    
    function getLast()
    {
        $c = new Criteria();
        $c->add(KategoriaPeer::DVD_ID, $this->options->getDvdId());
        $c->setLimit(1);                                
        $c->addDescendingOrderByColumn(KategoriaPeer::SLUG);
        if ($tmp = KategoriaPeer::doSelectOne($c)) {
            $this->ptr_last = $tmp;
            if ($this->ptr_current && ($this->ptr_last->getSlug() == $this->ptr_current->getSlug())) {
                $this->ptr_last = false;
            }
        }    
    }    

}