<?php

require 'autokomis/om/BaseAuto.php';


/**
 * Skeleton subclass for representing a row from the 'auto' table.
 *
 * 
 *
 * You should add additional methods to this class to meet the
 * application requirements.  This class will only be generated as
 * long as it does not already exist in the output directory.
 *
 * @package    autokomis
 */
class Auto extends BaseAuto {

	/**
	 * Initializes internal state of Auto object.
	 * @see        parent::__construct()
	 */
	public function __construct()
	{
		// Make sure that parent constructor is always invoked, since that
		// is where any default values for this object are set.
		parent::__construct();
	}
	
	public function __toString()
	{
	    return $this->getModel()->getMarka() . ' ' . $this->getModel() . ' ' . $this->getTyp();
	}
	
	public function setSlug($slug)
	{
        if (trim($slug) == '') {
            $slug = 'nieznany';
        }

        $next_slug = $slug;
        $c = new Criteria();
        $c->add(AutoPeer::SLUG, $next_slug);
        $ile = AutoPeer::doCount($c);

        $unikatowy = ($ile == 0);

        $min = 2;
        $max = 100000;

        while (!$unikatowy) {

	        $next_slug = $slug . $min;
            $min++;

	        if ($min > $max + 1) {
	             die("****** ERROR    Auto::setSlug({$next_slug})");
	        };

            $c->clear();
            $c->add(AutoPeer::SLUG, $next_slug);
            $ile = AutoPeer::doCount($c);
            $unikatowy = ($ile == 0);

        }

        parent::setSlug($next_slug);
	}
	
	public function podajWyposazenie()
	{
	    $wynik = array();
	    $tmp = $this->getAutoHasWyposazeniesJoinWyposazenie();
	    foreach ($tmp as $w) {
	        $wynik[] = $w->getWyposazenie();
	    }
	    return $wynik;

	}



} // Auto
