<?php


abstract class SortColumns {

    protected $index;
    protected $columns;    
    
    protected $current_order = false;
    
    private static $orders = array('asc', 'dsc');
    
    protected $base_url;
    
    public function isValidOrder($order)
    {
        return in_array($order, self::$orders);
    }    

    public function isValidSlug($slug)
    {
        return in_array($slug, array_keys($this->columns));
    }

    public function getColumns()
    {
        return $this->columns;
    }    
    
    public function setIndex($index)
    {
        $this->index = $index;
        $this->setCurrentOrder();
    }        
    
    public function getIndex()
    {
        return $this->index;
    }
    
    public function setOrder($order)
    {
        $this->current_order = $order;
        $this->columns[$this->index]['order'] = $order;
    }            
    
    public function getOrder()
    {
        return $this->columns[$this->index]['order'];
    }
    
    public function setCurrentOrder()
    {
        $this->current_order = $this->getOrder();
    }
    
    public function getCurrentOrder()
    {
        return $this->current_order;
    }
    
    public function reverseOrder()
    {
        if ($this->columns[$this->index]['order'] == 'asc') {
            $this->columns[$this->index]['order'] = 'dsc';
        } else {
            $this->columns[$this->index]['order'] = 'asc';
        }
    }                
    
    public function incorrectVars()
    {
        if (
            (isset($_GET['orderslug']) && !$this->isValidSlug($_GET['orderslug'])) ||
            (isset($_GET['order']) && !$this->isValidOrder($_GET['order']))
	) {
            return true;
        } else {
            return false;
        }
    }
    
    public function correctVars()
    {
        if (
            isset($_GET['orderslug']) &&
            $this->isValidSlug($_GET['orderslug'])  &&
            isset($_GET['order']) &&    
            $this->isValidOrder($_GET['order'])
        ) {
            return true;
        } else {
            return false;
        }
    }    
    
    
    public function assignCurrent()
    {
        if ($this->current_order) {
            $this->columns[$this->index]['current'] = $this->current_order;
        } else {
            $this->columns[$this->index]['current'] = $this->columns[$this->index]['order'];
        }
    }
    
    public function setBaseURL($url)
    {
        return $this->base_url = $url;
    }
    
    public function getBaseURL()
    {
        return $this->base_url;
    }
    
    public function addURLs($baseurl)
    {
        $this->setBaseURL($baseurl);
        $keys = array_keys($this->columns);
        foreach ($keys as $key) {
            $this->columns[$key]['url'] =
                $this->base_url .
                '&order=' . $this->columns[$key]['order'] .
                '&orderslug=' . $this->columns[$key]['slug'];
        }
        
    }
    
    public function getCriteria()
    {
        $c = new Criteria();
        if ($this->columns[$this->index]['order'] == 'asc') {
            $c->addAscendingOrderByColumn($this->columns[$this->index]['column']);
        } else {
            $c->addDescendingOrderByColumn($this->columns[$this->index]['column']);
        }
        return $c;
    }
    
}