set names utf8;
drop database if exists treny;
create database treny default character set utf8 collate utf8_polish_ci;
grant all on treny.* to admin@localhost identified by 'password';
flush privileges;
use treny;


# This is a fix for InnoDB in MySQL >= 4.1.x
# It "suspends judgement" for fkey relationships until are tables are set.
SET FOREIGN_KEY_CHECKS = 0;

#-----------------------------------------------------------------------------
#-- tren
#-----------------------------------------------------------------------------

DROP TABLE IF EXISTS `tren`;


CREATE TABLE `tren`
(
	`tren_id` INTEGER  NOT NULL AUTO_INCREMENT,
	`tytul` VARCHAR(255),
	`tresc` TEXT,
	`slug` VARCHAR(45),
	`numer` INTEGER,
	PRIMARY KEY (`tren_id`),
	UNIQUE KEY `tren_U_1` (`slug`(45))
)Type=InnoDB;

# This restores the fkey checks, after having unset them earlier
SET FOREIGN_KEY_CHECKS = 1;
