<?php


/**
 * This class adds structure of 'pracownik' table to 'angaze' DatabaseMap object.
 *
 *
 *
 * These statically-built map classes are used by Propel to do runtime db structure discovery.
 * For example, the createSelectSql() method checks the type of a given column used in an
 * ORDER BY clause to know whether it needs to apply SQL to make the ORDER BY case-insensitive
 * (i.e. if it's a text column type).
 *
 * @package    angaze.map
 */
class PracownikMapBuilder implements MapBuilder {

	/**
	 * The (dot-path) name of this class
	 */
	const CLASS_NAME = 'angaze.map.PracownikMapBuilder';

	/**
	 * The database map.
	 */
	private $dbMap;

	/**
	 * Tells us if this DatabaseMapBuilder is built so that we
	 * don't have to re-build it every time.
	 *
	 * @return     boolean true if this DatabaseMapBuilder is built, false otherwise.
	 */
	public function isBuilt()
	{
		return ($this->dbMap !== null);
	}

	/**
	 * Gets the databasemap this map builder built.
	 *
	 * @return     the databasemap
	 */
	public function getDatabaseMap()
	{
		return $this->dbMap;
	}

	/**
	 * The doBuild() method builds the DatabaseMap
	 *
	 * @return     void
	 * @throws     PropelException
	 */
	public function doBuild()
	{
		$this->dbMap = Propel::getDatabaseMap(PracownikPeer::DATABASE_NAME);

		$tMap = $this->dbMap->addTable(PracownikPeer::TABLE_NAME);
		$tMap->setPhpName('Pracownik');
		$tMap->setClassname('Pracownik');

		$tMap->setUseIdGenerator(true);

		$tMap->addPrimaryKey('PRACOWNIK_ID', 'PracownikId', 'INTEGER', true, null);

		$tMap->addColumn('IMIE', 'Imie', 'VARCHAR', false, 20);

		$tMap->addColumn('NAZWISKO', 'Nazwisko', 'VARCHAR', false, 45);

		$tMap->addColumn('SKROT', 'Skrot', 'VARCHAR', false, 20);

		$tMap->addColumn('TYTUL', 'Tytul', 'VARCHAR', false, 20);

		$tMap->addForeignKey('POKOJ_ID', 'PokojId', 'INTEGER', 'pokoj', 'POKOJ_ID', false, null);

		$tMap->addForeignKey('STANOWISKO_ID', 'StanowiskoId', 'INTEGER', 'stanowisko', 'STANOWISKO_ID', false, null);

		$tMap->addForeignKey('KATEDRA_ID', 'KatedraId', 'INTEGER', 'katedra', 'KATEDRA_ID', false, null);

		$tMap->addColumn('SLUG', 'Slug', 'VARCHAR', true, 128);

	} // doBuild()

} // PracownikMapBuilder
