<?php

require_once 'XML/Serializer.php';

$serializer = new XML_Serializer();

$options = array(
    'addDecl'        => true,
    'indent'         => '    ',
    'rootName'       => 'nagrody',
    'encoding'       => 'utf-8',
    'defaultTagName' => 'nagroda',
);

$serializer->setOptions($options);

$dane = array();

$plik = file('nobel.txt');
foreach ($plik as $linia) {
    $e = explode('|', trim($linia)); 
    $tmp = array(
        'rok'        => $e[0],
        'fizyka'     => $e[1],
        'chemia'     => $e[2],
        'medycyna'   => $e[3],
        'literatura' => $e[4],
        'pokojowa'   => $e[5]
    );
    array_push($dane, $tmp);
}

$serializer->serialize($dane);

$wynik = $serializer->getSerializedData();

file_put_contents('nobel.xml', $wynik);
