<?php

/**
 * Base class that represents a row from the 'rocznik' table.
 *
 * 
 *
 * @package    artykulymi.om
 */
abstract class BaseRocznik extends BaseObject  implements Persistent {


	/**
	 * The Peer class.
	 * Instance provides a convenient way of calling static methods on a class
	 * that calling code may not be able to identify.
	 * @var        RocznikPeer
	 */
	protected static $peer;

	/**
	 * The value for the rocznik_id field.
	 * @var        int
	 */
	protected $rocznik_id;

	/**
	 * The value for the rok field.
	 * @var        int
	 */
	protected $rok;

	/**
	 * The value for the liczbaartykulow field.
	 * @var        int
	 */
	protected $liczbaartykulow;

	/**
	 * The value for the liczbastron field.
	 * @var        int
	 */
	protected $liczbastron;

	/**
	 * The value for the slug field.
	 * @var        string
	 */
	protected $slug;

	/**
	 * @var        array Numer[] Collection to store aggregation of Numer objects.
	 */
	protected $collNumers;

	/**
	 * @var        Criteria The criteria used to select the current contents of collNumers.
	 */
	private $lastNumerCriteria = null;

	/**
	 * Flag to prevent endless save loop, if this object is referenced
	 * by another object which falls in this transaction.
	 * @var        boolean
	 */
	protected $alreadyInSave = false;

	/**
	 * Flag to prevent endless validation loop, if this object is referenced
	 * by another object which falls in this transaction.
	 * @var        boolean
	 */
	protected $alreadyInValidation = false;

	/**
	 * Initializes internal state of BaseRocznik object.
	 * @see        applyDefaults()
	 */
	public function __construct()
	{
		parent::__construct();
		$this->applyDefaultValues();
	}

	/**
	 * Applies default values to this object.
	 * This method should be called from the object's constructor (or
	 * equivalent initialization method).
	 * @see        __construct()
	 */
	public function applyDefaultValues()
	{
	}

	/**
	 * Get the [rocznik_id] column value.
	 * 
	 * @return     int
	 */
	public function getRocznikId()
	{
		return $this->rocznik_id;
	}

	/**
	 * Get the [rok] column value.
	 * 
	 * @return     int
	 */
	public function getRok()
	{
		return $this->rok;
	}

	/**
	 * Get the [liczbaartykulow] column value.
	 * 
	 * @return     int
	 */
	public function getLiczbaartykulow()
	{
		return $this->liczbaartykulow;
	}

	/**
	 * Get the [liczbastron] column value.
	 * 
	 * @return     int
	 */
	public function getLiczbastron()
	{
		return $this->liczbastron;
	}

	/**
	 * Get the [slug] column value.
	 * 
	 * @return     string
	 */
	public function getSlug()
	{
		return $this->slug;
	}

	/**
	 * Set the value of [rocznik_id] column.
	 * 
	 * @param      int $v new value
	 * @return     Rocznik The current object (for fluent API support)
	 */
	public function setRocznikId($v)
	{
		if ($v !== null) {
			$v = (int) $v;
		}

		if ($this->rocznik_id !== $v) {
			$this->rocznik_id = $v;
			$this->modifiedColumns[] = RocznikPeer::ROCZNIK_ID;
		}

		return $this;
	} // setRocznikId()

	/**
	 * Set the value of [rok] column.
	 * 
	 * @param      int $v new value
	 * @return     Rocznik The current object (for fluent API support)
	 */
	public function setRok($v)
	{
		if ($v !== null) {
			$v = (int) $v;
		}

		if ($this->rok !== $v) {
			$this->rok = $v;
			$this->modifiedColumns[] = RocznikPeer::ROK;
		}

		return $this;
	} // setRok()

	/**
	 * Set the value of [liczbaartykulow] column.
	 * 
	 * @param      int $v new value
	 * @return     Rocznik The current object (for fluent API support)
	 */
	public function setLiczbaartykulow($v)
	{
		if ($v !== null) {
			$v = (int) $v;
		}

		if ($this->liczbaartykulow !== $v) {
			$this->liczbaartykulow = $v;
			$this->modifiedColumns[] = RocznikPeer::LICZBAARTYKULOW;
		}

		return $this;
	} // setLiczbaartykulow()

	/**
	 * Set the value of [liczbastron] column.
	 * 
	 * @param      int $v new value
	 * @return     Rocznik The current object (for fluent API support)
	 */
	public function setLiczbastron($v)
	{
		if ($v !== null) {
			$v = (int) $v;
		}

		if ($this->liczbastron !== $v) {
			$this->liczbastron = $v;
			$this->modifiedColumns[] = RocznikPeer::LICZBASTRON;
		}

		return $this;
	} // setLiczbastron()

	/**
	 * Set the value of [slug] column.
	 * 
	 * @param      string $v new value
	 * @return     Rocznik The current object (for fluent API support)
	 */
	public function setSlug($v)
	{
		if ($v !== null) {
			$v = (string) $v;
		}

		if ($this->slug !== $v) {
			$this->slug = $v;
			$this->modifiedColumns[] = RocznikPeer::SLUG;
		}

		return $this;
	} // setSlug()

	/**
	 * Indicates whether the columns in this object are only set to default values.
	 *
	 * This method can be used in conjunction with isModified() to indicate whether an object is both
	 * modified _and_ has some values set which are non-default.
	 *
	 * @return     boolean Whether the columns in this object are only been set with default values.
	 */
	public function hasOnlyDefaultValues()
	{
			// First, ensure that we don't have any columns that have been modified which aren't default columns.
			if (array_diff($this->modifiedColumns, array())) {
				return false;
			}

		// otherwise, everything was equal, so return TRUE
		return true;
	} // hasOnlyDefaultValues()

	/**
	 * Hydrates (populates) the object variables with values from the database resultset.
	 *
	 * An offset (0-based "start column") is specified so that objects can be hydrated
	 * with a subset of the columns in the resultset rows.  This is needed, for example,
	 * for results of JOIN queries where the resultset row includes columns from two or
	 * more tables.
	 *
	 * @param      array $row The row returned by PDOStatement->fetch(PDO::FETCH_NUM)
	 * @param      int $startcol 0-based offset column which indicates which restultset column to start with.
	 * @param      boolean $rehydrate Whether this object is being re-hydrated from the database.
	 * @return     int next starting column
	 * @throws     PropelException  - Any caught Exception will be rewrapped as a PropelException.
	 */
	public function hydrate($row, $startcol = 0, $rehydrate = false)
	{
		try {

			$this->rocznik_id = ($row[$startcol + 0] !== null) ? (int) $row[$startcol + 0] : null;
			$this->rok = ($row[$startcol + 1] !== null) ? (int) $row[$startcol + 1] : null;
			$this->liczbaartykulow = ($row[$startcol + 2] !== null) ? (int) $row[$startcol + 2] : null;
			$this->liczbastron = ($row[$startcol + 3] !== null) ? (int) $row[$startcol + 3] : null;
			$this->slug = ($row[$startcol + 4] !== null) ? (string) $row[$startcol + 4] : null;
			$this->resetModified();

			$this->setNew(false);

			if ($rehydrate) {
				$this->ensureConsistency();
			}

			// FIXME - using NUM_COLUMNS may be clearer.
			return $startcol + 5; // 5 = RocznikPeer::NUM_COLUMNS - RocznikPeer::NUM_LAZY_LOAD_COLUMNS).

		} catch (Exception $e) {
			throw new PropelException("Error populating Rocznik object", $e);
		}
	}

	/**
	 * Checks and repairs the internal consistency of the object.
	 *
	 * This method is executed after an already-instantiated object is re-hydrated
	 * from the database.  It exists to check any foreign keys to make sure that
	 * the objects related to the current object are correct based on foreign key.
	 *
	 * You can override this method in the stub class, but you should always invoke
	 * the base method from the overridden method (i.e. parent::ensureConsistency()),
	 * in case your model changes.
	 *
	 * @throws     PropelException
	 */
	public function ensureConsistency()
	{

	} // ensureConsistency

	/**
	 * Reloads this object from datastore based on primary key and (optionally) resets all associated objects.
	 *
	 * This will only work if the object has been saved and has a valid primary key set.
	 *
	 * @param      boolean $deep (optional) Whether to also de-associated any related objects.
	 * @param      PropelPDO $con (optional) The PropelPDO connection to use.
	 * @return     void
	 * @throws     PropelException - if this object is deleted, unsaved or doesn't have pk match in db
	 */
	public function reload($deep = false, PropelPDO $con = null)
	{
		if ($this->isDeleted()) {
			throw new PropelException("Cannot reload a deleted object.");
		}

		if ($this->isNew()) {
			throw new PropelException("Cannot reload an unsaved object.");
		}

		if ($con === null) {
			$con = Propel::getConnection(RocznikPeer::DATABASE_NAME, Propel::CONNECTION_READ);
		}

		// We don't need to alter the object instance pool; we're just modifying this instance
		// already in the pool.

		$stmt = RocznikPeer::doSelectStmt($this->buildPkeyCriteria(), $con);
		$row = $stmt->fetch(PDO::FETCH_NUM);
		$stmt->closeCursor();
		if (!$row) {
			throw new PropelException('Cannot find matching row in the database to reload object values.');
		}
		$this->hydrate($row, 0, true); // rehydrate

		if ($deep) {  // also de-associate any related objects?

			$this->collNumers = null;
			$this->lastNumerCriteria = null;

		} // if (deep)
	}

	/**
	 * Removes this object from datastore and sets delete attribute.
	 *
	 * @param      PropelPDO $con
	 * @return     void
	 * @throws     PropelException
	 * @see        BaseObject::setDeleted()
	 * @see        BaseObject::isDeleted()
	 */
	public function delete(PropelPDO $con = null)
	{
		if ($this->isDeleted()) {
			throw new PropelException("This object has already been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(RocznikPeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
		}
		
		$con->beginTransaction();
		try {
			RocznikPeer::doDelete($this, $con);
			$this->setDeleted(true);
			$con->commit();
		} catch (PropelException $e) {
			$con->rollBack();
			throw $e;
		}
	}

	/**
	 * Persists this object to the database.
	 *
	 * If the object is new, it inserts it; otherwise an update is performed.
	 * All modified related objects will also be persisted in the doSave()
	 * method.  This method wraps all precipitate database operations in a
	 * single transaction.
	 *
	 * @param      PropelPDO $con
	 * @return     int The number of rows affected by this insert/update and any referring fk objects' save() operations.
	 * @throws     PropelException
	 * @see        doSave()
	 */
	public function save(PropelPDO $con = null)
	{
		if ($this->isDeleted()) {
			throw new PropelException("You cannot save an object that has been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(RocznikPeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
		}
		
		$con->beginTransaction();
		try {
			$affectedRows = $this->doSave($con);
			$con->commit();
			RocznikPeer::addInstanceToPool($this);
			return $affectedRows;
		} catch (PropelException $e) {
			$con->rollBack();
			throw $e;
		}
	}

	/**
	 * Performs the work of inserting or updating the row in the database.
	 *
	 * If the object is new, it inserts it; otherwise an update is performed.
	 * All related objects are also updated in this method.
	 *
	 * @param      PropelPDO $con
	 * @return     int The number of rows affected by this insert/update and any referring fk objects' save() operations.
	 * @throws     PropelException
	 * @see        save()
	 */
	protected function doSave(PropelPDO $con)
	{
		$affectedRows = 0; // initialize var to track total num of affected rows
		if (!$this->alreadyInSave) {
			$this->alreadyInSave = true;

			if ($this->isNew() ) {
				$this->modifiedColumns[] = RocznikPeer::ROCZNIK_ID;
			}

			// If this object has been modified, then save it to the database.
			if ($this->isModified()) {
				if ($this->isNew()) {
					$pk = RocznikPeer::doInsert($this, $con);
					$affectedRows += 1; // we are assuming that there is only 1 row per doInsert() which
										 // should always be true here (even though technically
										 // BasePeer::doInsert() can insert multiple rows).

					$this->setRocznikId($pk);  //[IMV] update autoincrement primary key

					$this->setNew(false);
				} else {
					$affectedRows += RocznikPeer::doUpdate($this, $con);
				}

				$this->resetModified(); // [HL] After being saved an object is no longer 'modified'
			}

			if ($this->collNumers !== null) {
				foreach ($this->collNumers as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			$this->alreadyInSave = false;

		}
		return $affectedRows;
	} // doSave()

	/**
	 * Array of ValidationFailed objects.
	 * @var        array ValidationFailed[]
	 */
	protected $validationFailures = array();

	/**
	 * Gets any ValidationFailed objects that resulted from last call to validate().
	 *
	 *
	 * @return     array ValidationFailed[]
	 * @see        validate()
	 */
	public function getValidationFailures()
	{
		return $this->validationFailures;
	}

	/**
	 * Validates the objects modified field values and all objects related to this table.
	 *
	 * If $columns is either a column name or an array of column names
	 * only those columns are validated.
	 *
	 * @param      mixed $columns Column name or an array of column names.
	 * @return     boolean Whether all columns pass validation.
	 * @see        doValidate()
	 * @see        getValidationFailures()
	 */
	public function validate($columns = null)
	{
		$res = $this->doValidate($columns);
		if ($res === true) {
			$this->validationFailures = array();
			return true;
		} else {
			$this->validationFailures = $res;
			return false;
		}
	}

	/**
	 * This function performs the validation work for complex object models.
	 *
	 * In addition to checking the current object, all related objects will
	 * also be validated.  If all pass then <code>true</code> is returned; otherwise
	 * an aggreagated array of ValidationFailed objects will be returned.
	 *
	 * @param      array $columns Array of column names to validate.
	 * @return     mixed <code>true</code> if all validations pass; array of <code>ValidationFailed</code> objets otherwise.
	 */
	protected function doValidate($columns = null)
	{
		if (!$this->alreadyInValidation) {
			$this->alreadyInValidation = true;
			$retval = null;

			$failureMap = array();


			if (($retval = RocznikPeer::doValidate($this, $columns)) !== true) {
				$failureMap = array_merge($failureMap, $retval);
			}


				if ($this->collNumers !== null) {
					foreach ($this->collNumers as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}


			$this->alreadyInValidation = false;
		}

		return (!empty($failureMap) ? $failureMap : true);
	}

	/**
	 * Retrieves a field from the object by name passed in as a string.
	 *
	 * @param      string $name name
	 * @param      string $type The type of fieldname the $name is of:
	 *                     one of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME
	 *                     BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM
	 * @return     mixed Value of field.
	 */
	public function getByName($name, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = RocznikPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		$field = $this->getByPosition($pos);
		return $field;
	}

	/**
	 * Retrieves a field from the object by Position as specified in the xml schema.
	 * Zero-based.
	 *
	 * @param      int $pos position in xml schema
	 * @return     mixed Value of field at $pos
	 */
	public function getByPosition($pos)
	{
		switch($pos) {
			case 0:
				return $this->getRocznikId();
				break;
			case 1:
				return $this->getRok();
				break;
			case 2:
				return $this->getLiczbaartykulow();
				break;
			case 3:
				return $this->getLiczbastron();
				break;
			case 4:
				return $this->getSlug();
				break;
			default:
				return null;
				break;
		} // switch()
	}

	/**
	 * Exports the object as an array.
	 *
	 * You can specify the key type of the array by passing one of the class
	 * type constants.
	 *
	 * @param      string $keyType (optional) One of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME
	 *                        BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM. Defaults to BasePeer::TYPE_PHPNAME.
	 * @param      boolean $includeLazyLoadColumns (optional) Whether to include lazy loaded columns.  Defaults to TRUE.
	 * @return     an associative array containing the field names (as keys) and field values
	 */
	public function toArray($keyType = BasePeer::TYPE_PHPNAME, $includeLazyLoadColumns = true)
	{
		$keys = RocznikPeer::getFieldNames($keyType);
		$result = array(
			$keys[0] => $this->getRocznikId(),
			$keys[1] => $this->getRok(),
			$keys[2] => $this->getLiczbaartykulow(),
			$keys[3] => $this->getLiczbastron(),
			$keys[4] => $this->getSlug(),
		);
		return $result;
	}

	/**
	 * Sets a field from the object by name passed in as a string.
	 *
	 * @param      string $name peer name
	 * @param      mixed $value field value
	 * @param      string $type The type of fieldname the $name is of:
	 *                     one of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME
	 *                     BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM
	 * @return     void
	 */
	public function setByName($name, $value, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = RocznikPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->setByPosition($pos, $value);
	}

	/**
	 * Sets a field from the object by Position as specified in the xml schema.
	 * Zero-based.
	 *
	 * @param      int $pos position in xml schema
	 * @param      mixed $value field value
	 * @return     void
	 */
	public function setByPosition($pos, $value)
	{
		switch($pos) {
			case 0:
				$this->setRocznikId($value);
				break;
			case 1:
				$this->setRok($value);
				break;
			case 2:
				$this->setLiczbaartykulow($value);
				break;
			case 3:
				$this->setLiczbastron($value);
				break;
			case 4:
				$this->setSlug($value);
				break;
		} // switch()
	}

	/**
	 * Populates the object using an array.
	 *
	 * This is particularly useful when populating an object from one of the
	 * request arrays (e.g. $_POST).  This method goes through the column
	 * names, checking to see whether a matching key exists in populated
	 * array. If so the setByName() method is called for that column.
	 *
	 * You can specify the key type of the array by additionally passing one
	 * of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME,
	 * BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM.
	 * The default key type is the column's phpname (e.g. 'AuthorId')
	 *
	 * @param      array  $arr     An array to populate the object from.
	 * @param      string $keyType The type of keys the array uses.
	 * @return     void
	 */
	public function fromArray($arr, $keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = RocznikPeer::getFieldNames($keyType);

		if (array_key_exists($keys[0], $arr)) $this->setRocznikId($arr[$keys[0]]);
		if (array_key_exists($keys[1], $arr)) $this->setRok($arr[$keys[1]]);
		if (array_key_exists($keys[2], $arr)) $this->setLiczbaartykulow($arr[$keys[2]]);
		if (array_key_exists($keys[3], $arr)) $this->setLiczbastron($arr[$keys[3]]);
		if (array_key_exists($keys[4], $arr)) $this->setSlug($arr[$keys[4]]);
	}

	/**
	 * Build a Criteria object containing the values of all modified columns in this object.
	 *
	 * @return     Criteria The Criteria object containing all modified values.
	 */
	public function buildCriteria()
	{
		$criteria = new Criteria(RocznikPeer::DATABASE_NAME);

		if ($this->isColumnModified(RocznikPeer::ROCZNIK_ID)) $criteria->add(RocznikPeer::ROCZNIK_ID, $this->rocznik_id);
		if ($this->isColumnModified(RocznikPeer::ROK)) $criteria->add(RocznikPeer::ROK, $this->rok);
		if ($this->isColumnModified(RocznikPeer::LICZBAARTYKULOW)) $criteria->add(RocznikPeer::LICZBAARTYKULOW, $this->liczbaartykulow);
		if ($this->isColumnModified(RocznikPeer::LICZBASTRON)) $criteria->add(RocznikPeer::LICZBASTRON, $this->liczbastron);
		if ($this->isColumnModified(RocznikPeer::SLUG)) $criteria->add(RocznikPeer::SLUG, $this->slug);

		return $criteria;
	}

	/**
	 * Builds a Criteria object containing the primary key for this object.
	 *
	 * Unlike buildCriteria() this method includes the primary key values regardless
	 * of whether or not they have been modified.
	 *
	 * @return     Criteria The Criteria object containing value(s) for primary key(s).
	 */
	public function buildPkeyCriteria()
	{
		$criteria = new Criteria(RocznikPeer::DATABASE_NAME);

		$criteria->add(RocznikPeer::ROCZNIK_ID, $this->rocznik_id);

		return $criteria;
	}

	/**
	 * Returns the primary key for this object (row).
	 * @return     int
	 */
	public function getPrimaryKey()
	{
		return $this->getRocznikId();
	}

	/**
	 * Generic method to set the primary key (rocznik_id column).
	 *
	 * @param      int $key Primary key.
	 * @return     void
	 */
	public function setPrimaryKey($key)
	{
		$this->setRocznikId($key);
	}

	/**
	 * Sets contents of passed object to values from current object.
	 *
	 * If desired, this method can also make copies of all associated (fkey referrers)
	 * objects.
	 *
	 * @param      object $copyObj An object of Rocznik (or compatible) type.
	 * @param      boolean $deepCopy Whether to also copy all rows that refer (by fkey) to the current row.
	 * @throws     PropelException
	 */
	public function copyInto($copyObj, $deepCopy = false)
	{

		$copyObj->setRok($this->rok);

		$copyObj->setLiczbaartykulow($this->liczbaartykulow);

		$copyObj->setLiczbastron($this->liczbastron);

		$copyObj->setSlug($this->slug);


		if ($deepCopy) {
			// important: temporarily setNew(false) because this affects the behavior of
			// the getter/setter methods for fkey referrer objects.
			$copyObj->setNew(false);

			foreach ($this->getNumers() as $relObj) {
				if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
					$copyObj->addNumer($relObj->copy($deepCopy));
				}
			}

		} // if ($deepCopy)


		$copyObj->setNew(true);

		$copyObj->setRocznikId(NULL); // this is a auto-increment column, so set to default value

	}

	/**
	 * Makes a copy of this object that will be inserted as a new row in table when saved.
	 * It creates a new object filling in the simple attributes, but skipping any primary
	 * keys that are defined for the table.
	 *
	 * If desired, this method can also make copies of all associated (fkey referrers)
	 * objects.
	 *
	 * @param      boolean $deepCopy Whether to also copy all rows that refer (by fkey) to the current row.
	 * @return     Rocznik Clone of current object.
	 * @throws     PropelException
	 */
	public function copy($deepCopy = false)
	{
		// we use get_class(), because this might be a subclass
		$clazz = get_class($this);
		$copyObj = new $clazz();
		$this->copyInto($copyObj, $deepCopy);
		return $copyObj;
	}

	/**
	 * Returns a peer instance associated with this om.
	 *
	 * Since Peer classes are not to have any instance attributes, this method returns the
	 * same instance for all member of this class. The method could therefore
	 * be static, but this would prevent one from overriding the behavior.
	 *
	 * @return     RocznikPeer
	 */
	public function getPeer()
	{
		if (self::$peer === null) {
			self::$peer = new RocznikPeer();
		}
		return self::$peer;
	}

	/**
	 * Clears out the collNumers collection (array).
	 *
	 * This does not modify the database; however, it will remove any associated objects, causing
	 * them to be refetched by subsequent calls to accessor method.
	 *
	 * @return     void
	 * @see        addNumers()
	 */
	public function clearNumers()
	{
		$this->collNumers = null; // important to set this to NULL since that means it is uninitialized
	}

	/**
	 * Initializes the collNumers collection (array).
	 *
	 * By default this just sets the collNumers collection to an empty array (like clearcollNumers());
	 * however, you may wish to override this method in your stub class to provide setting appropriate
	 * to your application -- for example, setting the initial array to the values stored in database.
	 *
	 * @return     void
	 */
	public function initNumers()
	{
		$this->collNumers = array();
	}

	/**
	 * Gets an array of Numer objects which contain a foreign key that references this object.
	 *
	 * If this collection has already been initialized with an identical Criteria, it returns the collection.
	 * Otherwise if this Rocznik has previously been saved, it will retrieve
	 * related Numers from storage. If this Rocznik is new, it will return
	 * an empty collection or the current collection, the criteria is ignored on a new object.
	 *
	 * @param      PropelPDO $con
	 * @param      Criteria $criteria
	 * @return     array Numer[]
	 * @throws     PropelException
	 */
	public function getNumers($criteria = null, PropelPDO $con = null)
	{
		if ($criteria === null) {
			$criteria = new Criteria(RocznikPeer::DATABASE_NAME);
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collNumers === null) {
			if ($this->isNew()) {
			   $this->collNumers = array();
			} else {

				$criteria->add(NumerPeer::ROCZNIK_ID, $this->rocznik_id);

				NumerPeer::addSelectColumns($criteria);
				$this->collNumers = NumerPeer::doSelect($criteria, $con);
			}
		} else {
			// criteria has no effect for a new object
			if (!$this->isNew()) {
				// the following code is to determine if a new query is
				// called for.  If the criteria is the same as the last
				// one, just return the collection.


				$criteria->add(NumerPeer::ROCZNIK_ID, $this->rocznik_id);

				NumerPeer::addSelectColumns($criteria);
				if (!isset($this->lastNumerCriteria) || !$this->lastNumerCriteria->equals($criteria)) {
					$this->collNumers = NumerPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastNumerCriteria = $criteria;
		return $this->collNumers;
	}

	/**
	 * Returns the number of related Numer objects.
	 *
	 * @param      Criteria $criteria
	 * @param      boolean $distinct
	 * @param      PropelPDO $con
	 * @return     int Count of related Numer objects.
	 * @throws     PropelException
	 */
	public function countNumers(Criteria $criteria = null, $distinct = false, PropelPDO $con = null)
	{
		if ($criteria === null) {
			$criteria = new Criteria(RocznikPeer::DATABASE_NAME);
		} else {
			$criteria = clone $criteria;
		}

		if ($distinct) {
			$criteria->setDistinct();
		}

		$count = null;

		if ($this->collNumers === null) {
			if ($this->isNew()) {
				$count = 0;
			} else {

				$criteria->add(NumerPeer::ROCZNIK_ID, $this->rocznik_id);

				$count = NumerPeer::doCount($criteria, $con);
			}
		} else {
			// criteria has no effect for a new object
			if (!$this->isNew()) {
				// the following code is to determine if a new query is
				// called for.  If the criteria is the same as the last
				// one, just return count of the collection.


				$criteria->add(NumerPeer::ROCZNIK_ID, $this->rocznik_id);

				if (!isset($this->lastNumerCriteria) || !$this->lastNumerCriteria->equals($criteria)) {
					$count = NumerPeer::doCount($criteria, $con);
				} else {
					$count = count($this->collNumers);
				}
			} else {
				$count = count($this->collNumers);
			}
		}
		$this->lastNumerCriteria = $criteria;
		return $count;
	}

	/**
	 * Method called to associate a Numer object to this object
	 * through the Numer foreign key attribute.
	 *
	 * @param      Numer $l Numer
	 * @return     void
	 * @throws     PropelException
	 */
	public function addNumer(Numer $l)
	{
		if ($this->collNumers === null) {
			$this->initNumers();
		}
		if (!in_array($l, $this->collNumers, true)) { // only add it if the **same** object is not already associated
			array_push($this->collNumers, $l);
			$l->setRocznik($this);
		}
	}

	/**
	 * Resets all collections of referencing foreign keys.
	 *
	 * This method is a user-space workaround for PHP's inability to garbage collect objects
	 * with circular references.  This is currently necessary when using Propel in certain
	 * daemon or large-volumne/high-memory operations.
	 *
	 * @param      boolean $deep Whether to also clear the references on all associated objects.
	 */
	public function clearAllReferences($deep = false)
	{
		if ($deep) {
			if ($this->collNumers) {
				foreach ((array) $this->collNumers as $o) {
					$o->clearAllReferences($deep);
				}
			}
		} // if ($deep)

		$this->collNumers = null;
	}

} // BaseRocznik
