<?php

header('Content-Type: text/plain;  charset=utf-8');

set_time_limit(0);

set_include_path(
    '../aplikacja/scripts' . PATH_SEPARATOR .
    '../aplikacja/scripts/include' . PATH_SEPARATOR .
    '../lib' . PATH_SEPARATOR .
    get_include_path()
);

require_once 'pomocnicze.inc.php';
require_once 'wskaznik-postepu.class.php';
require_once 'propel/Propel.php';
require_once 'artykulymi/Artykul.php';
require_once 'slugs.inc.php';

Propel::init('artykulymi-conf.php');

RocznikPeer::doDeleteAll();
AutorPeer::doDeleteAll();
RubrykaPeer::doDeleteAll();
PodrubrykaPeer::doDeleteAll();

$plks = glob('dane/*.xml');

$wsk = new WskaznikPostepu('artykuly', count($plks), 80);

foreach ($plks as $plk) {
    $wsk->next();
    $dane = parse_xml($plk);
    ArtykulPeer::insertParsedArticle($dane);
}

AutorPeer::przeliczArtykuly();
RocznikPeer::przeliczArtykuly();
NumerPeer::przeliczArtykuly();
RubrykaPeer::przeliczArtykuly();
PodrubrykaPeer::przeliczArtykuly();