<?php

require 'artykulymi/om/BaseArtykulPeer.php';


/**
 * Skeleton subclass for performing query and update operations on the 'artykul' table.
 *
 * 
 *
 * You should add additional methods to this class to meet the
 * application requirements.  This class will only be generated as
 * long as it does not already exist in the output directory.
 *
 * @package    artykulymi
 */
class ArtykulPeer extends BaseArtykulPeer {


    public static function insertParsedArticle($dane)
    {
        $dane_rocznik = array(
            'rok' => $dane['rocznik'],
            'slug' => string2slug($dane['rocznik'])
        );
        $rocznik = RocznikPeer::insertIfNotExists($dane_rocznik);

        $dane_numer = array(
            'numer' => $dane['numer'],
            'rocznik_id' => $rocznik->getRocznikId(),
            'slug' => string2slug($dane['rocznik'] . ' ' . $dane['numer'])
        );
        $numer = NumerPeer::insertIfNotExists($dane_numer);

        $dane_rubryka = array(
            'rubryka' => $dane['rubryka'],
            'slug' => string2slug($dane['rubryka'])
        );
        $rubryka = RubrykaPeer::insertIfNotExists($dane_rubryka);

        $dane_podrubryka = array(
            'podrubryka' => $dane['podrubryka'],
            'slug' => string2slug($dane['podrubryka'])
        );
        $podrubryka = PodrubrykaPeer::insertIfNotExists($dane_podrubryka);

        $dane_artykul = array(
            'numer_id' => $numer->getNumerId(),
            'rubryka_id' => $rubryka->getRubrykaId(),
            'podrubryka_id' => $podrubryka->getPodrubrykaId(),
            'tytul' => $dane['tytul'],
            'lid' => $dane['lid'],
            'start' => $dane['odstrony'],
            'stop' => $dane['dostrony'],
            'liczbastron' => $dane['dostrony'] - $dane['odstrony'] + 1,
            'slug' => string2slug($dane['tytul'])
        );
        $artykul = ArtykulPeer::insert($dane_artykul);

        foreach ($dane['autorzy'] as $tmp_autor) {

            $dane_autor = array(
                'imie' => $tmp_autor['imie'],
                'nazwisko' => $tmp_autor['nazwisko'],
                'slug' => string2slug($tmp_autor['nazwisko'] . ' ' . $tmp_autor['imie'])
            );

            $autor = AutorPeer::insertIfNotExists($dane_autor);

            $aha = new ArtykulHasAutor();
            $aha->setArtykul($artykul);
            $aha->setAutor($autor);
            try {
                $aha->save();
            } catch (PropelException $e) {
                echo $artykul . "\n";
                echo $autor . "\n";
                echo $plk . "\n";
                die('blad wstawiania: ArtykulHasAutor');
            }

        }
    }




    public static function insert($dane)
    {
        $tmp = new Artykul();
        $tmp->fromArray($dane, BasePeer::TYPE_FIELDNAME);
        $tmp->save();
        return $tmp;
    }


    static public function retrieveBySlug($slug)
    {
        $c = new Criteria();
        $c->add(self::SLUG, $slug);
        return parent::doSelectOne($c);
    }

} // ArtykulPeer
