<?php



class TabelaRubryk extends SortColumns {



    public function __construct()
    {
    
        $this->columns = array(

            'rubryka' => array(
                'order' => 'asc',
                'label' => 'Rubryka',
                'column' => RubrykaPeer::RUBRYKA,
                'slug' => 'rubryka',
                'sortable' => 'tak'
            ),
            'lart' => array(
                'order' => 'dsc',
                'label' => 'Liczba artykułów',
                'column' => RubrykaPeer::LICZBAARTYKULOW,
                'slug' => 'lart',
                'sortable' => 'tak'
            ),
            'lstr' => array(
                'order' => 'dsc',
                'label' => 'Liczba stron',
                'column' => RubrykaPeer::LICZBASTRON,
                'slug' => 'lstr',
                'sortable' => 'tak'
            ),
        );            
        
        $this->setIndex('rubryka');
    }
    
    public function getCriteria()
    {


        $c = new Criteria();

        if ($this->columns[$this->index]['order'] == 'asc') {
            $c->addAscendingOrderByColumn($this->columns[$this->index]['column']);
        } else {
            $c->addDescendingOrderByColumn($this->columns[$this->index]['column']);
        }
        
        return $c;        
    }
    

}