<?php


class TabelaArtykulow extends SortColumns {



    public function __construct()
    {
        $this->columns = array(

            'tytul' => array(
                'order' => 'asc',
                'label' => 'Tytuł',
                'column' => ArtykulPeer::TYTUL,
                'slug' => 'tytul',
                'sortable' => 'tak'
            ),
            'numer' => array(
                'order' => 'asc',
                'label' => 'Numer',
                'slug' => 'numer',
                'sortable' => 'tak'
            ),
            'rubryka' => array(
                'order' => '',
                'sortable' => 'nie',
                'label' => 'Rubryka',
                'slug' => '',
            ),    
            'stron' => array(
                'order' => 'dsc',
                'label' => 'Liczba stron',
                'column' => ArtykulPeer::LICZBASTRON,
                'slug' => 'stron',
                'sortable' => 'tak'
            ),
        );

        $this->setIndex('numer');
    }
    
    public function getCriteria()
    {
        $c = new Criteria();
        
        switch ($this->columns[$this->index]['slug']) {
        
        case 'tytul':
            if ($this->columns[$this->index]['order'] == 'asc') {
                $c->addAscendingOrderByColumn($this->columns[$this->index]['column']);
            } else {
                $c->addDescendingOrderByColumn($this->columns[$this->index]['column']);
            }
            break;
        
        case 'numer':
            if ($this->columns[$this->index]['order'] == 'asc') {
                $c->addAscendingOrderByColumn(RocznikPeer::ROK);
                $c->addAscendingOrderByColumn(NumerPeer::NUMER);

            } else {
                $c->addDescendingOrderByColumn(RocznikPeer::ROK);
                $c->addDescendingOrderByColumn(NumerPeer::NUMER);
            }
            
            $c->addJoin(ArtykulPeer::NUMER_ID, NumerPeer::NUMER_ID);
            $c->addJoin(NumerPeer::ROCZNIK_ID, RocznikPeer::ROCZNIK_ID);

            break;
            
        case 'stron':
            if ($this->columns[$this->index]['order'] == 'asc') {
                $c->addAscendingOrderByColumn($this->columns[$this->index]['column']);
            } else {
                $c->addDescendingOrderByColumn($this->columns[$this->index]['column']);
            }
            break;
        
        }
        
        return $c;        
    }
    

}