<?php

require 'artykulymi/om/BaseArtykul.php';


/**
 * Skeleton subclass for representing a row from the 'artykul' table.
 *
 * 
 *
 * You should add additional methods to this class to meet the
 * application requirements.  This class will only be generated as
 * long as it does not already exist in the output directory.
 *
 * @package    artykulymi
 */
class Artykul extends BaseArtykul {

	/**
	 * Initializes internal state of Artykul object.
	 * @see        parent::__construct()
	 */
	public function __construct()
	{
		// Make sure that parent constructor is always invoked, since that
		// is where any default values for this object are set.
		parent::__construct();
	}
	
	
	public function setSlug($slug)
	{
        if (trim($slug) == '') {
            $slug = 'nieznany';
        }

        $next_slug = $slug;
        $c = new Criteria();
        $c->add(ArtykulPeer::SLUG, $next_slug);
        $ile = ArtykulPeer::doCount($c);

        $unikatowy = ($ile == 0);

        $min = 2;
        $max = 10000;

        while (!$unikatowy) {

	        $next_slug = $slug . $min;
            $min++;

	        if ($min > $max + 1) {
	             die("****** ERROR    Artykul::setSlug({$next_slug})");
	        };

            $c->clear();
            $c->add(ArtykulPeer::SLUG, $next_slug);
            $ile = ArtykulPeer::doCount($c);
            $unikatowy = ($ile == 0);
        }
        parent::setSlug($next_slug);
	}

	
	
	public function __toString()
	{
	    return $this->getTytul();
	}
	
	public function getNumerPelny()
	{
	    return $this->getNumer() . '/' . $this->getNumer()->getRocznik();
	}
	
	public function podajAutorow()
	{
	    $wynik = array();
        foreach ($this->getArtykulHasAutorsJoinAutor() as $aha) {
            $wynik[] = $aha->getAutor();
        }
        return $wynik;
	}
	
	public function getRubrykaSlug()
	{
	    return $this->getRubryka()->getSlug();
	}
	
	public function getPodrubrykaSlug()
	{
	    return $this->getPodrubryka()->getSlug();
	}
	
	public function getNumerSlug()
	{
	    return $this->getNumer()->getSlug();
	}
	
	public function getRocznikSlug()
	{
	    return $this->getNumer()->getRocznik()->getSlug();
	}
	
	public function getRocznik()
	{
	    return $this->getNumer()->getRocznik();
	}

} // Artykul
