<?php



class WskaznikAutora extends Pointer
{

    protected function getFirst()
    {
        $c = new Criteria();
        $c->setLimit(1);
        $c->addAscendingOrderByColumn(AutorPeer::NAZWISKO);
        $c->addAscendingOrderByColumn(AutorPeer::IMIE);
        if ($tmp = AutorPeer::doSelectOne($c)) {
            $this->ptr_first = $tmp;
            if ($this->ptr_current && ($this->ptr_first->getSlug() == $this->ptr_current->getSlug())) {
                $this->ptr_first = false;
            }
        }    
    }
    
    
    protected function getPrevious()
    {
        if ($this->ptr_current) {
            $c = new Criteria();

            //nazwisko rwne, a imie mniejsze
            $cton1 = $c->getNewCriterion(AutorPeer::NAZWISKO, $this->ptr_current->getNazwisko());
            $cton2 = $c->getNewCriterion(AutorPeer::IMIE, $this->ptr_current->getImie(), Criteria::LESS_THAN);
            $cton1->addAnd($cton2);

            //nazwisko mniejsze
            $cton3 = $c->getNewCriterion(AutorPeer::NAZWISKO, $this->ptr_current->getNazwisko(), Criteria::LESS_THAN);

            $cton1->addOr($cton3);

            $c->add($cton1);


            $c->setLimit(1);
            $c->addDescendingOrderByColumn(AutorPeer::NAZWISKO);
            $c->addDescendingOrderByColumn(AutorPeer::IMIE);
            if ($tmp = AutorPeer::doSelectOne($c)) {
                $this->ptr_previous = $tmp;
            }            
        };    
    }    
    
    protected function getNext()
    {
        if ($this->ptr_current) {
            $c = new Criteria();


            //nazwisko rwne, a imie wiksze
            $cton1 = $c->getNewCriterion(AutorPeer::NAZWISKO, $this->ptr_current->getNazwisko());
            $cton2 = $c->getNewCriterion(AutorPeer::IMIE, $this->ptr_current->getImie(), Criteria::GREATER_THAN);
            $cton1->addAnd($cton2);

            //nazwisko wiksze
            $cton3 = $c->getNewCriterion(AutorPeer::NAZWISKO, $this->ptr_current->getNazwisko(), Criteria::GREATER_THAN);

            $cton1->addOr($cton3);

            $c->add($cton1);


            $c->setLimit(1);          
            $c->addAscendingOrderByColumn(AutorPeer::NAZWISKO);
            $c->addAscendingOrderByColumn(AutorPeer::IMIE);
            if ($tmp = AutorPeer::doSelectOne($c)) {
                $this->ptr_next = $tmp;
            }            
        }
    }        
    
    
    protected function getLast()
    {
        $c = new Criteria();
        $c->setLimit(1);                                
        $c->addDescendingOrderByColumn(AutorPeer::NAZWISKO);
        $c->addDescendingOrderByColumn(AutorPeer::IMIE);
        if ($tmp = AutorPeer::doSelectOne($c)) {
            $this->ptr_last = $tmp;
            if ($this->ptr_current && ($this->ptr_last->getSlug() == $this->ptr_current->getSlug())) {
                $this->ptr_last = false;
            }
        }    
    }    
    
    



}