<?php


/**
 * This class adds structure of 'song' table to 'records' DatabaseMap object.
 *
 *
 *
 * These statically-built map classes are used by Propel to do runtime db structure discovery.
 * For example, the createSelectSql() method checks the type of a given column used in an
 * ORDER BY clause to know whether it needs to apply SQL to make the ORDER BY case-insensitive
 * (i.e. if it's a text column type).
 *
 * @package    records.map
 */
class SongMapBuilder implements MapBuilder {

	/**
	 * The (dot-path) name of this class
	 */
	const CLASS_NAME = 'records.map.SongMapBuilder';

	/**
	 * The database map.
	 */
	private $dbMap;

	/**
	 * Tells us if this DatabaseMapBuilder is built so that we
	 * don't have to re-build it every time.
	 *
	 * @return     boolean true if this DatabaseMapBuilder is built, false otherwise.
	 */
	public function isBuilt()
	{
		return ($this->dbMap !== null);
	}

	/**
	 * Gets the databasemap this map builder built.
	 *
	 * @return     the databasemap
	 */
	public function getDatabaseMap()
	{
		return $this->dbMap;
	}

	/**
	 * The doBuild() method builds the DatabaseMap
	 *
	 * @return     void
	 * @throws     PropelException
	 */
	public function doBuild()
	{
		$this->dbMap = Propel::getDatabaseMap(SongPeer::DATABASE_NAME);

		$tMap = $this->dbMap->addTable(SongPeer::TABLE_NAME);
		$tMap->setPhpName('Song');
		$tMap->setClassname('Song');

		$tMap->setUseIdGenerator(true);

		$tMap->addPrimaryKey('SONG_ID', 'SongId', 'INTEGER', true, null);

		$tMap->addColumn('TITLE', 'Title', 'VARCHAR', false, 255);

		$tMap->addColumn('LYRICS', 'Lyrics', 'LONGVARCHAR', false, null);

		$tMap->addForeignKey('RECORD_ID', 'RecordId', 'INTEGER', 'record', 'RECORD_ID', false, null);

		$tMap->addColumn('SLUG', 'Slug', 'VARCHAR', false, 128);

		$tMap->addColumn('NUMER', 'Numer', 'INTEGER', false, null);

	} // doBuild()

} // SongMapBuilder
