<?php

header('Content-Type: application/xml');

require_once 'XML/Serializer.php';

$serializer = new XML_Serializer();

$dane = array(
    array(
        'imie' => 'Jan',
        'nazwisko' => 'Nowak',
        'plec' => 'M',
        'dataurodzenia' => array(
            'dzien' => '24', 
            'miesiac' => '5',
            'rok' => '1967'    
        )    
    ),
    array(
        'imie' => 'Piotr',
        'nazwisko' => 'Kowalski',
        'plec' => 'M',        
        'dataurodzenia' => array(
            'dzien' => '3', 
            'miesiac' => '11',
            'rok' => '1976'    
        )    
    ),    
);

$options = array(
    'addDecl'  => true,
    'indent'   => '    ',
    'rootName' => 'osoby',
    'encoding' => 'utf-8',
    'defaultTagName' => 'osoba',    
    'scalarAsAttributes' => array('osoba' => array('plec'), 'dataurodzenia' => array('rok', 'dzien'))
);

$serializer->setOptions($options);

$serializer->serialize($dane);

$wynik = $serializer->getSerializedData();

echo $wynik;
