<?php

require 'football2002/om/BaseKlub.php';


/**
 * Skeleton subclass for representing a row from the 'klub' table.
 *
 * 
 *
 * You should add additional methods to this class to meet the
 * application requirements.  This class will only be generated as
 * long as it does not already exist in the output directory.
 *
 * @package    football2002
 */
class Klub extends BaseKlub {

	/**
	 * Initializes internal state of Klub object.
	 * @see        parent::__construct()
	 */
	public function __construct()
	{
		// Make sure that parent constructor is always invoked, since that
		// is where any default values for this object are set.
		parent::__construct();
	}
	
	public function __toString()
	{
	    return $this->getNazwa();
	}
	
    function tabela()
    {
        $sql = "
            SELECT
                k.klub_id as klub_id,
                k.liga_id as liga_id,
                SUM(
                    (@remis := IF (m.gol1 = m.gol2, 1, 0)) +
                    (@zwyciestwo :=
                        IF (
                            (m.gol1 > m.gol2 AND m.gospodarz = k.klub_id) OR
                            (m.gol1 < m.gol2 AND m.gosc = k.klub_id),
                            1,
                            0
                        )
                    ) * 3
                ) as punkty,
                SUM(
                    IF (m.gospodarz = k.klub_id OR m.gosc = k.klub_id, 1, 0)
                ) as mecze,
                SUM(@zwyciestwo) as zwyciestwa,
                SUM(@remis) as remisy,
                SUM(
                    IF (
                        (m.gol1 < m.gol2 AND m.gospodarz = k.klub_id) OR
                        (m.gol1 > m.gol2 AND m.gosc = k.klub_id),
                        1,
                        0
                    )
                ) as przegrane,
                SUM(
                    IF (m.gospodarz = k.klub_id, m.gol1, m.gol2)
                ) as bramkizdobyte,
                SUM(
                    IF (m.gospodarz = k.klub_id, m.gol2, m.gol1)
                ) as bramkistracone
            FROM
                klub as k,
                mecz as m
            WHERE
                k.klub_id = {$this->getKlubId()} AND
                (m.gospodarz = k.klub_id  OR m.gosc = k.klub_id)
        ";

        $connection = Propel::getConnection();
        $statement = $connection->prepare($sql);
        $statement->setFetchMode(PDO::FETCH_ASSOC);
        $statement->execute();
        $wynik = $statement->fetch();

        return $wynik;
    }

} // Klub
