<?php


class Actions extends ActionsBase
{

    public function execute_tabela()
    {
        if (
            isset($_GET['slug']) &&
            str_ivslug($_GET['slug']) &&
            ($liga = LigaPeer::retrieveBySlug($_GET['slug']))            
        ) {    
            $base_url =
                'index.php?module=liga&action=tabela&slug=' .
                $liga->getSlug();
        
            $kolumny = new TabelaWynikow();
            
            if ($kolumny->incorrectVars()) {
                $this->execute_404();                
                return;
            } else if ($kolumny->correctVars()) {
                $kolumny->setIndex($_GET['orderslug']);    
                $kolumny->setOrder($_GET['order']);
            }
            
            $kolumny->assignCurrent();
            $c = $kolumny->getCriteria();
            $kolumny->reverseOrder();
            $kolumny->addURLs($base_url);
            
            $this->set('wybrana_liga', $liga);            
            $this->set('tabela', $liga->getTabelas($c));                        
            $this->set('kolumny', $kolumny->getColumns());
            

        } else {
            $this->execute_404();
        }
    }              
    
    
    public function execute_kluby()
    {
        if (
            isset($_GET['slug']) &&
            str_ivslug($_GET['slug']) &&
            ($liga = LigaPeer::retrieveBySlug($_GET['slug']))            
        ) {    
            $base_url =
                'index.php?module=liga&action=kluby&slug=' .
                $liga->getSlug();
                
            $kolumny = new TabelaKlubow();
            
            if ($kolumny->incorrectVars()) {
                $this->execute_404();                
                return;
            } else if ($kolumny->correctVars()) {
                $kolumny->setIndex($_GET['orderslug']);    
                $kolumny->setOrder($_GET['order']);
            }
            
            $kolumny->assignCurrent();
            
            $c = $kolumny->getCriteria();
            $kolumny->reverseOrder();       
            $kolumny->addURLs($base_url);
            
            $this->set('wybrana_liga', $liga);            
            $this->set('kluby',  $liga->getKlubs($c));            
            $this->set('kolumny', $kolumny->getColumns());

        } else {
            $this->execute_404();
        }
    }                  
    
    public function execute_mecze()
    {
        if (
            isset($_GET['slug']) &&
            str_ivslug($_GET['slug']) &&
            ($liga = LigaPeer::retrieveBySlug($_GET['slug']))            
        ) {    
            $base_url =
                'index.php?module=liga&action=mecze&slug=' .
                $liga->getSlug();
        
            $kolumny = new TabelaMeczow();
            
            if ($kolumny->incorrectVars()) {
                $this->execute_404();                
                return;
            } else if ($kolumny->correctVars()) {
                $kolumny->setIndex($_GET['orderslug']);    
                $kolumny->setOrder($_GET['order']);
            }
            
            $kolumny->assignCurrent();
            
            $c = $kolumny->getCriteria($liga);
            $kolumny->reverseOrder();            
            $kolumny->addURLs($base_url);
            
            $this->set('wybrana_liga', $liga);
            $this->set('mecze', $liga->podajMecze($c));
            $this->set('kolumny', $kolumny->getColumns());            

        } else {
            $this->execute_404();
        }
    }                      
    
    
}