<?php

abstract class Pointer 
{
    public $ptr_current      = false;
    public $options          = false;
    
    protected $ptr_first     = false;
    protected $ptr_previous  = false;
    protected $ptr_next      = false;
    protected $ptr_last      = false;

    
    public function setCurrent($current)
    {
        if ($current) {
            $this->ptr_current = $current;
        };
    }
    
    public function setOptions($options)
    {
        if ($options) {
            $this->options = $options;
        };
    }
    
    abstract protected function getFirst();
    abstract protected function getPrevious();
    abstract protected function getNext();
    abstract protected function getLast();
    
    public function __construct($current = false, $options = false)
    {
    
        $this->setCurrent($current);
        $this->setOptions($options);
        
        $this->getFirst();
        $this->getPrevious();
        $this->getNext();
        $this->getLast();		   
    }
    
    
    public function getPointers()
    {
        return array(
            'first' => $this->ptr_first,
            'previous' => $this->ptr_previous,
            'next' => $this->ptr_next,
            'last' => $this->ptr_last,
        );
    }

}