<?php

set_include_path(
    '../aplikacja/scripts' . PATH_SEPARATOR .
    '../aplikacja/scripts/include' . PATH_SEPARATOR .
    '../lib' . PATH_SEPARATOR .
    get_include_path()
);

require_once 'propel/Propel.php';
require_once 'football2002/Klub.php';
Propel::init('football2002-conf.php');

require_once 'vh-array.inc.php';
require_once 'slugs.inc.php';

LigaPeer::doDeleteAll();

//TabelaPeer::doDeleteAll();
//KlubPeer::doDeleteAll();
//MeczPeer::doDeleteAll();


$plk = file_get_contents('dane/mecze.txt');
$dane = string2HArray(trim($plk), ':');
foreach ($dane['items'] as $wiersz) {

    $str_liga       = $wiersz[0];
    $str_kolejka    = $wiersz[1];    
    $str_data       = $wiersz[2];        
    $str_gospodarz  = $wiersz[3];        
    $str_gosc       = $wiersz[4];        
    $str_gol1       = $wiersz[5];        
    $str_gol2       = $wiersz[6];        
    
    $dane_ligi = array(
        'nazwa' => $str_liga,
        'slug' =>  string2slug($str_liga)
    );
    $liga = LigaPeer::insertIfNotExists($dane_ligi);
    
    $dane_gospodarza = array(
        'nazwa' => $str_gospodarz,
        'slug' =>  string2slug($str_gospodarz),
        'liga_id' => $liga->getLigaId()
    );
    $gospodarz = KlubPeer::insertIfNotExists($dane_gospodarza);
    
    $dane_gosc = array(
        'nazwa' => $str_gosc,
        'slug' =>  string2slug($str_gosc),
        'liga_id' => $liga->getLigaId()
    );
    $gosc = KlubPeer::insertIfNotExists($dane_gosc);
    
    
    $dane_meczu = array(
        'gospodarz' => $gospodarz->getKlubId(),
        'gosc'      => $gosc->getKlubId(),
        'kolejka'   => $str_kolejka,
        'data'      => $str_data,
        'gol1'      => $str_gol1,
        'gol2'      => $str_gol2
    );
    MeczPeer::insert($dane_meczu);
    
}



/*
 * Tabela punktw
 *
 */
foreach (KlubPeer::doSelect() as $klub) {
    $punkty = $klub->tabela();
    TabelaPeer::insert($punkty);
}
