<?php


/**
 * This class adds structure of 'tabela' table to 'football2002' DatabaseMap object.
 *
 *
 *
 * These statically-built map classes are used by Propel to do runtime db structure discovery.
 * For example, the createSelectSql() method checks the type of a given column used in an
 * ORDER BY clause to know whether it needs to apply SQL to make the ORDER BY case-insensitive
 * (i.e. if it's a text column type).
 *
 * @package    football2002.map
 */
class TabelaMapBuilder implements MapBuilder {

	/**
	 * The (dot-path) name of this class
	 */
	const CLASS_NAME = 'football2002.map.TabelaMapBuilder';

	/**
	 * The database map.
	 */
	private $dbMap;

	/**
	 * Tells us if this DatabaseMapBuilder is built so that we
	 * don't have to re-build it every time.
	 *
	 * @return     boolean true if this DatabaseMapBuilder is built, false otherwise.
	 */
	public function isBuilt()
	{
		return ($this->dbMap !== null);
	}

	/**
	 * Gets the databasemap this map builder built.
	 *
	 * @return     the databasemap
	 */
	public function getDatabaseMap()
	{
		return $this->dbMap;
	}

	/**
	 * The doBuild() method builds the DatabaseMap
	 *
	 * @return     void
	 * @throws     PropelException
	 */
	public function doBuild()
	{
		$this->dbMap = Propel::getDatabaseMap(TabelaPeer::DATABASE_NAME);

		$tMap = $this->dbMap->addTable(TabelaPeer::TABLE_NAME);
		$tMap->setPhpName('Tabela');
		$tMap->setClassname('Tabela');

		$tMap->setUseIdGenerator(true);

		$tMap->addPrimaryKey('TABELA_ID', 'TabelaId', 'INTEGER', true, null);

		$tMap->addForeignKey('LIGA_ID', 'LigaId', 'INTEGER', 'liga', 'LIGA_ID', false, null);

		$tMap->addForeignKey('KLUB_ID', 'KlubId', 'INTEGER', 'klub', 'KLUB_ID', false, null);

		$tMap->addColumn('PUNKTY', 'Punkty', 'INTEGER', false, null);

		$tMap->addColumn('BRAMKISTRACONE', 'Bramkistracone', 'INTEGER', false, null);

		$tMap->addColumn('BRAMKIZDOBYTE', 'Bramkizdobyte', 'INTEGER', false, null);

		$tMap->addColumn('MECZE', 'Mecze', 'INTEGER', false, null);

		$tMap->addColumn('ZWYCIESTWA', 'Zwyciestwa', 'INTEGER', false, null);

		$tMap->addColumn('REMISY', 'Remisy', 'INTEGER', false, null);

		$tMap->addColumn('PRZEGRANE', 'Przegrane', 'INTEGER', false, null);

	} // doBuild()

} // TabelaMapBuilder
