<?php

require 'football2002/om/BaseLiga.php';


/**
 * Skeleton subclass for representing a row from the 'liga' table.
 *
 * 
 *
 * You should add additional methods to this class to meet the
 * application requirements.  This class will only be generated as
 * long as it does not already exist in the output directory.
 *
 * @package    football2002
 */
class Liga extends BaseLiga {

	/**
	 * Initializes internal state of Liga object.
	 * @see        parent::__construct()
	 */
	public function __construct()
	{
		// Make sure that parent constructor is always invoked, since that
		// is where any default values for this object are set.
		parent::__construct();
	}
	
	public function __toString()
	{
	    return $this->getNazwa();
	}
	
	public function podajMecze($c)
	{
        $c->add(LigaPeer::LIGA_ID, $this->getLigaId());
        $c->addJoin(KlubPeer::LIGA_ID, LigaPeer::LIGA_ID);
        /*
         * Konieczne jedno ze zcze:
         *
         *     $c->addJoin(KlubPeer::KLUB_ID, MeczPeer::GOSC);
         *     $c->addJoin(KlubPeer::KLUB_ID, MeczPeer::GOSC);
         *
         * Zczenie wykonujemy warunkowo w metodzie
         * getCriteria() klasy TabelaMeczow
         */
	    return MeczPeer::doSelect($c);
    }
	    

} // Liga
