<?php

error_reporting(E_ALL);
ini_set('display_errors', 1);

set_include_path(
    '../aplikacja/scripts' . PATH_SEPARATOR .
    '../aplikacja/scripts/include' . PATH_SEPARATOR .
    '../lib' . PATH_SEPARATOR .
    get_include_path()
);

require_once 'Doctrine/lib/Doctrine.php';
spl_autoload_register(array('Doctrine', 'autoload'));
$conn = Doctrine_Manager::connection('mysql://admin:password@localhost/noth');
Doctrine::loadModels('./../lib', Doctrine::MODEL_LOADING_CONSERVATIVE);
$conn->setCollate('utf8_polish_ci');
$conn->setCharset('utf8');

Doctrine::dropDatabases();
Doctrine::createDatabases();
Doctrine::createTablesFromModels();

require_once 'mimetypes.inc.php';
require_once 'vh-array.inc.php';


//ilustracje
$plks = glob('dane/ilustracje/*.png');
foreach ($plks as $plk) {

    $dane_img = array(
        'img'  => file_get_contents($plk),
        'slug' => preg_replace('/\.png$/', '', basename($plk))
    );

    img::insertIfNotExists($dane_img);

}



//download
$plks = glob('dane/download/*.*');
foreach ($plks as $plk) {

    $path_parts = pathinfo($plk);

    $dane_plik = array(
        'typmime' => get_mimetype_on_ext($path_parts['extension']),
        'dane'    => file_get_contents($plk),
        'slug'    => basename($plk)
    );

    plik::insertIfNotExists($dane_plik);
}



//menu
$plk = file_get_contents('dane/menu/00lista.log');
$d = string2HArray($plk);
foreach ($d['items'] as $tmp) {

    $nazwapliku = $tmp[2];

    $dane_menu = array(
        'slug'  => $tmp[0],
        'tytul' => $tmp[1],
        'tresc' => file_get_contents('dane/menu/' . $nazwapliku)
    );

    menu::insertIfNotExists($dane_menu);
}


//podrcznik uytkownika
$plk = file_get_contents('dane/pu/00lista.log');
$d = string2HArray($plk);
foreach ($d['items'] as $tmp) {

    $nazwapliku = $tmp[2];
    $dane_pu = array(
        'slug'  => $tmp[0],
        'tytul' => $tmp[1],
        'tresc' => file_get_contents('dane/pu/' . $nazwapliku)
    );
    
    pu::insertIfNotExists($dane_pu);
}


//skrty
$plk = file_get_contents('dane/skroty/00lista.log');
$d = string2HArray($plk);
foreach ($d['items'] as $tmp) {

    $nazwapliku = $tmp[2];
    
    $dane_skroty = array(
        'slug'  => $tmp[0],
        'tytul' => $tmp[1],
        'tresc' => file_get_contents('dane/skroty/' . $nazwapliku)
    );
    
    $skroty = skroty::insertIfNotExists($dane_skroty);
    
    $grupy_tmp = preg_split('/\r?\n@\r?\n/', $dane_skroty['tresc']);
    foreach ($grupy_tmp as $tmp_grupa) {
        $dane_grupy = array(
            'skroty_id' => $skroty['skroty_id']
        );
        
        $grupa = Grupa::insert($dane_grupy);
        
        $tmp_skroty = string2HArray($tmp_grupa);
        
        foreach ($tmp_skroty['items'] as $tmp_skrot) {
            $dane_skrotu = array(
                'grupa_id' => $grupa['grupa_id'],
                'skrot' => $tmp_skrot[0],
                'opis'  => $tmp_skrot[1],
                'kod'   => $tmp_skrot[2],
            );
            
            skrot::insert($dane_skrotu);

        }
            
    
    }        
    
}


