<?php

error_reporting(E_ALL);
ini_set('display_errors', 1);

set_include_path(
    '../aplikacja/scripts' . PATH_SEPARATOR .
    '../aplikacja/scripts/include' . PATH_SEPARATOR .
    '../lib' . PATH_SEPARATOR .
    get_include_path()
);

require_once 'propel/Propel.php';

require_once 'aparatyfoto/Aparat.php';
require_once 'aparatyfoto/Matryca.php';
require_once 'aparatyfoto/Producent.php';

Propel::init('aparatyfoto-conf.php');

require_once 'slugs.inc.php';

AparatPeer::doDeleteAll();
ProducentPeer::doDeleteAll();
MatrycaPeer::doDeleteAll();

require_once 'vh-array.inc.php';

$plks = glob('dane/*.txt');
shuffle($plks);
foreach ($plks as $plk) {

    $dane = loadAssocArray($plk);

    $producent = ProducentPeer::insertIfNotExists($dane['producent']);
    $matryca = MatrycaPeer::insertIfNotExists($dane['matryca']);

    $dane['producent_id'] = $producent->getProducentId();
    $dane['matryca_id'] = $matryca->getMatrycaId();
    $dane['slug'] = string2slug($dane['model']);

/*
 * Domylnie w toArray(), fromArray() --- BasePeer::TYPE_PHPNAME
 *
 * czyli MatrycaId, ProducentId, PodgladBieli, itd.
 */

    $aparat = new Aparat();
    $aparat->fromArray($dane, BasePeer::TYPE_FIELDNAME);
    $aparat->save();

}