<?php

require_once 'XML/Serializer.php';

$serializer = new XML_Serializer();


$options = array(
    'addDecl'        => true,
    'indent'         => '    ',
    'rootName'       => 'turniej-czterech-skoczni',
    'encoding'       => 'utf-8',
    'defaultTagName' => array(
        'turniej-czterech-skoczni' => 'zawody', 
        'miejsca' => 'miejsce'
    ),
    'scalarAsAttributes' => array(
        'zawody' => true,
        'miejsce' => array('numer')    
    )
);

$serializer->setOptions($options);



$dane = array();

$plik = file('tcs.txt');
foreach ($plik as $linia) {
    $e = explode('|', trim($linia)); 
    $tmp = array(
        'rok' => $e[0],
        'miejsca' => array(
            array(
                'numer'    => $e[1],
                'imie'     => $e[2],
                'nazwisko' => $e[3],
                'kraj'     => $e[4],				                
            ),
            array(
                'numer'    => $e[5],
                'imie'     => $e[6],
                'nazwisko' => $e[7],
                'kraj'     => $e[8],				                
            ),            
            array(
                'numer'    => $e[9],
                'imie'     => $e[10],
                'nazwisko' => $e[11],
                'kraj'     => $e[12],				                
            ),            
            
        )
    );
    array_push($dane, $tmp);
}

$serializer->serialize($dane);

$wynik = $serializer->getSerializedData();

file_put_contents('tcs.xml', $wynik);
