<?php

set_include_path(
    '../aplikacja/scripts' . PATH_SEPARATOR .
    '../aplikacja/scripts/include' . PATH_SEPARATOR .
    '../lib' . PATH_SEPARATOR .
    get_include_path()
);

require_once 'propel/Propel.php';
require_once 'phppp/Menu.php';
Propel::init('phppp-conf.php');

function numerek($n)
{
    if ($n == 0) {
        return '0';
    } else if ($n < 10) {
        return '0' . $n;
    } else {
        return "$n";    
    }
}

MenuPeer::doDeleteAll();
CzescPeer::doDeleteAll();

//dziki FOREIGN KEY: CASCADE zbdne
//tabele rozdzial oraz projekt zostan wyczyszczone
//przy czyszczeniu tabeli czesc
//ProjektPeer::doDeleteAll();
//RozdzialPeer::doDeleteAll();



/*
 * CZESC
 */
$plk = file('dane/czesc.txt'); 
$plk_c = count($plk);
for ($i = 0; $i < $plk_c; $i++) {
    $el = explode('|', trim($plk[$i]));
    
    $tab_dane = array(
        'tytul' => trim($el[0]) . ': ' . trim($el[1]),
        'numer' => $i + 1
    );
    
    CzescPeer::insert($tab_dane);
    
}

/*
 * ROZDZIAL
 */ 
$plk = file('dane/rozdzial.txt'); 
$plk_c = count($plk);
for ($i = 0; $i < $plk_c; $i++) {
    $el = explode('|', trim($plk[$i]));
    
    $tytul = trim($el[0]);
    $skrot = trim($el[0]);
    $numer = trim($el[1]);
    $czesc = trim($el[2]);
    
    $objCzesc = CzescPeer::findOneByNumer($czesc);
    if (!$objCzesc) {
        die('Problem #1');
    }
    
    $tab_dane = array(
        'tytul' => $tytul,
        'numer' => $numer,
        'slug' => numerek($numer),
        'czesc_id' => $objCzesc->getCzescId()
    );
    
    RozdzialPeer::insert($tab_dane);
    
}



/*
 * PROJEKT
 */ 
$plk = file('dane/projekt.txt'); 
$plk_c = count($plk);
for ($i = 0; $i < $plk_c; $i++) {
    $el = explode('|', trim($plk[$i]));
    
    $rozdzial = trim($el[0]);
    $numer = trim($el[1]);
    $numerpelny = "{$rozdzial}.{$numer}";
    $folder = trim($el[2]);
    $tytul = trim($el[3]);   
    $plik = trim($el[4]);        
    $preview = trim($el[5]);            
    if ($preview == 'PREVIEW') {
        $preview = true;
    } else {
        $preview = false;
    }
    
    $dane_nazwapliku =   '../aplikacja/www/projekty-dane/' . $folder . '-dane.zip';
    $dane =  file_exists($dane_nazwapliku);
    
    $objRozdzial = RozdzialPeer::findOneByNumer($rozdzial);
    
    if (!$objRozdzial) {
        die('Problem #2');
    }
    
    $tab_dane = array(
        'rozdzial_id' => $objRozdzial->getRozdzialId(),
        'tytul'       => $tytul,
        'numer'       => $numer,
        'numerpelny'  => $numerpelny,
        'folder'      => $folder,
        'slug'        => $folder,
        'dane'        => $dane,
        'plik'        => $plik,
        'preview'     => $preview
    );
    
    ProjektPeer::insert($tab_dane);
    
}

/*
 * MENU
 */ 
$plk = file('dane/menu/dane-menu.txt'); 
$plk_c = count($plk);
for ($i = 0; $i < $plk_c; $i++) {
    $el = explode('|', trim($plk[$i]));
    
    $tytul = trim($el[0]);
    $plik = trim($el[1]);    
    $tekst = trim(file_get_contents('dane/menu/' . $plik . '.txt'));
    $slug = trim($el[1]);        
    
    $tab_dane = array(
        'tytul' => $tytul,
        'tekst' => $tekst,
        'slug'  => $slug
    );
    
    MenuPeer::insert($tab_dane);

}
