
# This is a fix for InnoDB in MySQL >= 4.1.x
# It "suspends judgement" for fkey relationships until are tables are set.
SET FOREIGN_KEY_CHECKS = 0;

#-----------------------------------------------------------------------------
#-- rozdzial
#-----------------------------------------------------------------------------

DROP TABLE IF EXISTS `rozdzial`;


CREATE TABLE `rozdzial`
(
	`rozdzial_id` INTEGER  NOT NULL AUTO_INCREMENT,
	`czesc_id` INTEGER  NOT NULL,
	`tytul` VARCHAR(255),
	`numer` INTEGER,
	`slug` VARCHAR(45),
	PRIMARY KEY (`rozdzial_id`),
	UNIQUE KEY `rozdzial_U_1` (`slug`(45)),
	KEY `rozdzial_I_1`(`czesc_id`),
	CONSTRAINT `fk_czesc`
		FOREIGN KEY (`czesc_id`)
		REFERENCES `czesc` (`czesc_id`)
		ON UPDATE CASCADE
		ON DELETE CASCADE
)Type=InnoDB;

#-----------------------------------------------------------------------------
#-- projekt
#-----------------------------------------------------------------------------

DROP TABLE IF EXISTS `projekt`;


CREATE TABLE `projekt`
(
	`projekt_id` INTEGER  NOT NULL AUTO_INCREMENT,
	`rozdzial_id` INTEGER  NOT NULL,
	`tytul` VARCHAR(255),
	`numer` INTEGER,
	`numerpelny` VARCHAR(20),
	`folder` VARCHAR(45),
	`plik` VARCHAR(45),
	`dane` INTEGER,
	`preview` INTEGER,
	`slug` VARCHAR(45),
	PRIMARY KEY (`projekt_id`),
	UNIQUE KEY `projekt_U_1` (`slug`(45)),
	KEY `projekt_I_1`(`rozdzial_id`),
	CONSTRAINT `fk_rozdzial`
		FOREIGN KEY (`rozdzial_id`)
		REFERENCES `rozdzial` (`rozdzial_id`)
		ON UPDATE CASCADE
		ON DELETE CASCADE
)Type=InnoDB;

#-----------------------------------------------------------------------------
#-- menu
#-----------------------------------------------------------------------------

DROP TABLE IF EXISTS `menu`;


CREATE TABLE `menu`
(
	`menu_id` INTEGER  NOT NULL AUTO_INCREMENT,
	`tytul` TEXT,
	`tekst` TEXT,
	`slug` VARCHAR(255),
	PRIMARY KEY (`menu_id`),
	UNIQUE KEY `menu_U_1` (`slug`(255))
)Type=InnoDB;

#-----------------------------------------------------------------------------
#-- czesc
#-----------------------------------------------------------------------------

DROP TABLE IF EXISTS `czesc`;


CREATE TABLE `czesc`
(
	`czesc_id` INTEGER  NOT NULL AUTO_INCREMENT,
	`tytul` VARCHAR(255),
	`numer` INTEGER,
	PRIMARY KEY (`czesc_id`)
)Type=InnoDB;

# This restores the fkey checks, after having unset them earlier
SET FOREIGN_KEY_CHECKS = 1;
