<?php

set_include_path(
    '../aplikacja/scripts' . PATH_SEPARATOR .
    '../aplikacja/scripts/include' . PATH_SEPARATOR .
    '../lib' . PATH_SEPARATOR .
    get_include_path()
);

require_once 'slugs.inc.php';

error_reporting(E_ALL);
ini_set('display_errors', 1);

require_once 'Doctrine/lib/Doctrine.php';
spl_autoload_register(array('Doctrine', 'autoload'));
$conn = Doctrine_Manager::connection('mysql://admin:password@localhost/panstwa_miasta');

$conn->setCollate('utf8_polish_ci');
$conn->setCharset('utf8');

Doctrine::loadModels('./../lib');

Doctrine::dropDatabases();
Doctrine::createDatabases();
Doctrine::createTablesFromModels();

$plk = file('panstwa-miasta.txt');
shuffle($plk);
foreach ($plk as $l) {
    $miasta = explode(',', trim($l));
    $miasta = array_map('trim', $miasta);
    
    $str_kontynent = $miasta[0];
    $str_panstwo = $miasta[1];

    array_shift($miasta);
    array_shift($miasta);
    shuffle($miasta);
    

    $q = Doctrine_Query::create()
        ->from('Kontynent k')
        ->where('k.nazwa = ?', $str_kontynent);
    $kontynent = $q->fetchOne();
    if (!$kontynent) {
        $kontynent = new Kontynent();
        $kontynent['nazwa'] = $str_kontynent;
        $kontynent['slug'] = string2slug($str_kontynent);
        $kontynent->save();
    }
    
    $q = Doctrine_Query::create()
        ->from('Panstwo p')
        ->where('p.nazwa = ?', $str_panstwo);
    $panstwo = $q->fetchOne();
    if (!$panstwo) {
        $panstwo = new Panstwo();
        $panstwo['nazwa'] = $str_panstwo;
        $panstwo['slug'] = string2slug($str_panstwo);
        $panstwo['kontynent'] = $kontynent;
        $panstwo->save();
    }

    foreach ($miasta as $str_miasto) {
        $q = Doctrine_Query::create()
            ->from('Miasto m')
            ->where('m.nazwa = ?', $str_miasto);
        $miasto = $q->fetchOne();
        if (!$miasto) {
            $miasto = new Miasto();
            $miasto['nazwa'] = $str_miasto;
            $miasto['slug'] = string2slug($str_miasto);
            $miasto['panstwo'] = $panstwo;
            $miasto->save();
        }
    }
}