<?php

set_time_limit(0);
header('Content-Type: text/plain');

set_include_path(
    '../aplikacja/scripts' . PATH_SEPARATOR .
    '../aplikacja/scripts/include' . PATH_SEPARATOR .
    '../lib' . PATH_SEPARATOR .
    get_include_path()
);

require_once 'propel/Propel.php';
require_once 'records/Artist.php';
Propel::init('records-conf.php');

require_once 'random-lyrics.inc.php';
require_once 'slugs.inc.php';

YearPeer::doDeleteAll();
ArtistPeer::doDeleteAll();
SongPeer::doDeleteAll();
RecordPeer::doDeleteAll();

$lp_filenames = glob('txt-datafiles/*.txt');
shuffle($lp_filenames);
foreach ($lp_filenames as $lp_filename) {
    flush();
    ob_flush();
    $lp_file = file($lp_filename);
    
    
    //THE ARTIST
    $tmp_artist = trim($lp_file[0]);
    echo '*****' . $tmp_artist . "\n";
    $dane_artist = array(
        'name' => $tmp_artist,
        'slug' => string2slug($tmp_artist)
    );
    $artist = ArtistPeer::insertIfNotExists($dane_artist);
    
    
    //THE YEAR
    $tmp_year = trim($lp_file[2]);
    $dane_year = array(
        'year' => $tmp_year,
        'slug' => string2slug($tmp_year)
    );
    $year = YearPeer::insertIfNotExists($dane_year);

    
    
    //THE RECORD
    $tmp_record = trim($lp_file[1]);
    echo $tmp_record . "\n";
    $dane_record = array(
        'title' => $tmp_record,
        'slug' => string2slug($tmp_record),
        'artist_id' => $artist->getArtistId(),
        'year_id' => $year->getYearId(),
    );
    $record = RecordPeer::insertIfNotExists($dane_record);
  
    
    
    
    
    
    //THE SONGS
    $songs_count = count($lp_file);
    for ($i = 3; $i < $songs_count; $i++) {
        $e = explode('|', trim($lp_file[$i]));
        
        
        $dane_song = array(
            'title' => trim($e[0]),
            'slug' => string2slug(trim($e[0])),
            'lyrics' => random_lyrics($tab, count($tab)),
            'numer' => $i -2,
            'record_id' => $record->getRecordId(),
        );
        
        SongPeer::insert($dane_song);
        
        
    }

    
    
}
