set names utf8;
drop database if exists records;
create database records default character set utf8 collate utf8_polish_ci;
grant all on records.* to admin@localhost identified by 'password';
flush privileges;
use records;


# This is a fix for InnoDB in MySQL >= 4.1.x
# It "suspends judgement" for fkey relationships until are tables are set.
SET FOREIGN_KEY_CHECKS = 0;

#-----------------------------------------------------------------------------
#-- artist
#-----------------------------------------------------------------------------

DROP TABLE IF EXISTS `artist`;


CREATE TABLE `artist`
(
	`artist_id` INTEGER  NOT NULL AUTO_INCREMENT,
	`name` VARCHAR(45),
	`slug` VARCHAR(128),
	PRIMARY KEY (`artist_id`),
	UNIQUE KEY `artist_U_1` (`slug`(128))
)Type=InnoDB;

#-----------------------------------------------------------------------------
#-- song
#-----------------------------------------------------------------------------

DROP TABLE IF EXISTS `song`;


CREATE TABLE `song`
(
	`song_id` INTEGER  NOT NULL AUTO_INCREMENT,
	`title` VARCHAR(255),
	`lyrics` TEXT,
	`record_id` INTEGER,
	`slug` VARCHAR(128),
	`numer` INTEGER,
	PRIMARY KEY (`song_id`),
	UNIQUE KEY `song_U_1` (`slug`(128)),
	INDEX `FI_song_record` (`record_id`),
	CONSTRAINT `fk_song_record`
		FOREIGN KEY (`record_id`)
		REFERENCES `record` (`record_id`)
		ON UPDATE CASCADE
		ON DELETE CASCADE
)Type=InnoDB;

#-----------------------------------------------------------------------------
#-- record
#-----------------------------------------------------------------------------

DROP TABLE IF EXISTS `record`;


CREATE TABLE `record`
(
	`record_id` INTEGER  NOT NULL AUTO_INCREMENT,
	`title` VARCHAR(255),
	`year_id` INTEGER,
	`artist_id` INTEGER,
	`slug` VARCHAR(128),
	PRIMARY KEY (`record_id`),
	UNIQUE KEY `record_U_1` (`slug`(128)),
	INDEX `FI_record_year` (`year_id`),
	CONSTRAINT `fk_record_year`
		FOREIGN KEY (`year_id`)
		REFERENCES `year` (`year_id`)
		ON UPDATE CASCADE
		ON DELETE CASCADE,
	INDEX `FI_record_artist` (`artist_id`),
	CONSTRAINT `fk_record_artist`
		FOREIGN KEY (`artist_id`)
		REFERENCES `artist` (`artist_id`)
)Type=InnoDB;

#-----------------------------------------------------------------------------
#-- year
#-----------------------------------------------------------------------------

DROP TABLE IF EXISTS `year`;


CREATE TABLE `year`
(
	`year_id` INTEGER  NOT NULL AUTO_INCREMENT,
	`year` INTEGER,
	`slug` VARCHAR(128),
	PRIMARY KEY (`year_id`),
	UNIQUE KEY `year_U_1` (`slug`(128))
)Type=InnoDB;

# This restores the fkey checks, after having unset them earlier
SET FOREIGN_KEY_CHECKS = 1;
