<?php

class Actions extends ActionsBase
{

    public function execute_list()
    {
        if (isset($_GET['page'])) {    
            if (str_ievpi($_GET['page'])) {
                $strona = $_GET['page'];                
            } else {
                $this->execute_404();
                return;
            }
        } else {
            $strona = '1';
        }

        $pager = new Pager('Year', 10);
        
        if ($pager->isValidPage($strona)) {
            $pager->setPage($strona);
            $pager->assignRecords();            
            $pager->setBaseURL('index.php?module=year&action=list&page=');
            $this->set('pager', $pager);            
        } else {
            $this->execute_404();
        }        

    }              
    

    public function execute_show()
    {
        if (
            isset($_GET['slug']) &&
            str_ivslug($_GET['slug']) &&
            ($year = YearPeer::retrieveBySlug($_GET['slug']))            
        ) {    
            $this->set('year', $year);
            
            if (isset($_GET['page'])) {
                if (str_ievpi($_GET['page'])) {
                    $strona = $_GET['page'];
                } else {
                    $this->execute_404();
                    return;
                }
            } else {
                $strona = '1';
            }

            $c = new Criteria();
            $c->add(RecordPeer::YEAR_ID, $year->getYearId());

            $pager = new Pager('Record', 3, $c);

            if ($pager->isValidPage($strona)) {
                $pager->setPage($strona);
                $pager->assignRecords();
                $pager->setBaseURL('index.php?module=year&action=show&slug=' . $year->getSlug() . '&page=');
                $this->set('pager', $pager);
            } else {
                $this->execute_404();
            }
            
        } else {
            $this->execute_404();
        }
    }              
    
    
}
