<?php

class Actions extends ActionsBase
{

    public function execute_list()
    {
        if (isset($_GET['page'])) {    
            if (str_ievpi($_GET['page'])) {
                $strona = $_GET['page'];                
            } else {
                $this->execute_404();
                return;
            }
        } else {
            $strona = '1';
        }

        $pager = new Pager('Record', 25);
        
        if ($pager->isValidPage($strona)) {
            $pager->setPage($strona);
            $pager->assignRecords();            
            $this->set('pager', $pager);       
            $pager->setBaseURL('index.php?module=record&action=list&page=');
        } else {
            $this->execute_404();
        }        

    }              
    
    
    public function execute_show()
    {
        if (
            isset($_GET['slug']) &&
            str_ivslug($_GET['slug']) &&
            ($record = RecordPeer::retrieveBySlug($_GET['slug']))                    
        ) {    
        
            $this->set('record', $record);

            if (isset($_GET['page'])) {
                if (str_ievpi($_GET['page'])) {
                    $strona = $_GET['page'];
                } else {
                    $this->execute_404();
                    return;
                }
            } else {
                $strona = '1';
            }

            $c = new Criteria();
            $c->addAscendingOrderByColumn(SongPeer::NUMER);
            $c->add(SongPeer::RECORD_ID, $record->getRecordId());

            $pager = new Pager('Song', 7, $c);

            if ($pager->isValidPage($strona)) {
                $pager->setPage($strona);
                $pager->assignRecords();
                $pager->setBaseURL('index.php?module=record&action=show&slug=' . $record->getSlug() . '&page=');
                $this->set('pager', $pager);
            } else {
                $this->execute_404();
            }
                     
        } else {
            $this->execute_404();
        }
    }          
    
    
}
