set names utf8;
drop database if exists imiona;
create database imiona default character set utf8 collate utf8_polish_ci;
grant all on imiona.* to admin@localhost identified by 'password';
flush privileges;
use imiona;


# This is a fix for InnoDB in MySQL >= 4.1.x
# It "suspends judgement" for fkey relationships until are tables are set.
SET FOREIGN_KEY_CHECKS = 0;

#-----------------------------------------------------------------------------
#-- imie
#-----------------------------------------------------------------------------

DROP TABLE IF EXISTS `imie`;


CREATE TABLE `imie`
(
	`imie_id` INTEGER  NOT NULL AUTO_INCREMENT,
	`imie` VARCHAR(45)  NOT NULL,
	`slug` VARCHAR(128)  NOT NULL,
	PRIMARY KEY (`imie_id`),
	UNIQUE KEY `imie_U_1` (`slug`(128))
)Type=InnoDB;

# This restores the fkey checks, after having unset them earlier
SET FOREIGN_KEY_CHECKS = 1;
