<?php

require 'artykulymi/om/BaseRocznik.php';


/**
 * Skeleton subclass for representing a row from the 'rocznik' table.
 *
 * 
 *
 * You should add additional methods to this class to meet the
 * application requirements.  This class will only be generated as
 * long as it does not already exist in the output directory.
 *
 * @package    artykulymi
 */
class Rocznik extends BaseRocznik {

	/**
	 * Initializes internal state of Rocznik object.
	 * @see        parent::__construct()
	 */
	public function __construct()
	{
		// Make sure that parent constructor is always invoked, since that
		// is where any default values for this object are set.
		parent::__construct();
	}
	
	public function __toString()
	{
	    return (string)$this->getRok();
	}
	
	
	public function getArtykuls($criteria = null)
	{
        $criteria = new Criteria();
        $criteria->add(RocznikPeer::ROCZNIK_ID, $this->getRocznikId());
        $criteria->addJoin(ArtykulPeer::NUMER_ID, NumerPeer::NUMER_ID);
        $criteria->addJoin(NumerPeer::ROCZNIK_ID, RocznikPeer::ROCZNIK_ID);
	    return ArtykulPeer::doSelect($criteria);
	}
	
	
    public function przeliczArtykuly()
    {
        $arts = $this->getArtykuls();
        $this->setLiczbaartykulow(count($arts));
        $liczba_stron = 0;
        foreach ($arts as $art) {
            $liczba_stron += $art->getLiczbastron();
        }
        $this->setLiczbastron($liczba_stron);
        $this->save();
    }

} // Rocznik
