<?php

require 'artykulymi/om/BaseAutorPeer.php';


/**
 * Skeleton subclass for performing query and update operations on the 'autor' table.
 *
 * 
 *
 * You should add additional methods to this class to meet the
 * application requirements.  This class will only be generated as
 * long as it does not already exist in the output directory.
 *
 * @package    artykulymi
 */
class AutorPeer extends BaseAutorPeer {


    public static function insertIfNotExists($dane)
    {
        $c = new Criteria();
        $c->add(self::SLUG, $dane['slug']);
        $tmp = parent::doSelectOne($c);
        if (!$tmp) {
            $tmp = new Autor();
            $tmp->fromArray($dane, BasePeer::TYPE_FIELDNAME);
            $tmp->save();
        }
        return $tmp;
    }


    
    public static function przeliczArtykuly()
    {
        foreach (parent::doSelect(new Criteria()) as $obj) {
            $obj->przeliczArtykuly();
        }
    }
    
    static public function retrieveBySlug($slug)
    {
        $c = new Criteria();
        $c->add(self::SLUG, $slug);
        return parent::doSelectOne($c);
    }

    
    

} // AutorPeer
