
# This is a fix for InnoDB in MySQL >= 4.1.x
# It "suspends judgement" for fkey relationships until are tables are set.
SET FOREIGN_KEY_CHECKS = 0;

#-----------------------------------------------------------------------------
#-- autor
#-----------------------------------------------------------------------------

DROP TABLE IF EXISTS `autor`;


CREATE TABLE `autor`
(
	`autor_id` INTEGER  NOT NULL AUTO_INCREMENT,
	`imie` VARCHAR(255)  NOT NULL,
	`nazwisko` VARCHAR(255)  NOT NULL,
	`liczbaartykulow` INTEGER,
	`liczbastron` INTEGER,
	`slug` VARCHAR(128)  NOT NULL,
	PRIMARY KEY (`autor_id`),
	UNIQUE KEY `autor_U_1` (`slug`(128))
)Type=InnoDB;

#-----------------------------------------------------------------------------
#-- artykul
#-----------------------------------------------------------------------------

DROP TABLE IF EXISTS `artykul`;


CREATE TABLE `artykul`
(
	`artykul_id` INTEGER  NOT NULL AUTO_INCREMENT,
	`tytul` VARCHAR(255)  NOT NULL,
	`lid` TEXT,
	`start` INTEGER,
	`stop` INTEGER,
	`slug` VARCHAR(128)  NOT NULL,
	`rubryka_id` INTEGER,
	`podrubryka_id` INTEGER,
	`numer_id` INTEGER,
	`liczbastron` INTEGER,
	PRIMARY KEY (`artykul_id`),
	UNIQUE KEY `artykul_U_1` (`slug`(128)),
	INDEX `FI_artykul_rubryka1` (`rubryka_id`),
	CONSTRAINT `fk_artykul_rubryka1`
		FOREIGN KEY (`rubryka_id`)
		REFERENCES `rubryka` (`rubryka_id`)
		ON UPDATE CASCADE
		ON DELETE CASCADE,
	INDEX `FI_artykul_podrubryka1` (`podrubryka_id`),
	CONSTRAINT `fk_artykul_podrubryka1`
		FOREIGN KEY (`podrubryka_id`)
		REFERENCES `podrubryka` (`podrubryka_id`)
		ON UPDATE CASCADE
		ON DELETE CASCADE,
	INDEX `FI_artykul_numer1` (`numer_id`),
	CONSTRAINT `fk_artykul_numer1`
		FOREIGN KEY (`numer_id`)
		REFERENCES `numer` (`numer_id`)
		ON UPDATE CASCADE
		ON DELETE CASCADE
)Type=InnoDB;

#-----------------------------------------------------------------------------
#-- numer
#-----------------------------------------------------------------------------

DROP TABLE IF EXISTS `numer`;


CREATE TABLE `numer`
(
	`numer_id` INTEGER  NOT NULL AUTO_INCREMENT,
	`numer` INTEGER  NOT NULL,
	`liczbaartykulow` INTEGER,
	`liczbastron` INTEGER,
	`slug` VARCHAR(128)  NOT NULL,
	`rocznik_id` INTEGER,
	PRIMARY KEY (`numer_id`),
	UNIQUE KEY `numer_U_1` (`slug`(128)),
	INDEX `FI_numer_rocznik1` (`rocznik_id`),
	CONSTRAINT `fk_numer_rocznik1`
		FOREIGN KEY (`rocznik_id`)
		REFERENCES `rocznik` (`rocznik_id`)
		ON UPDATE CASCADE
		ON DELETE CASCADE
)Type=InnoDB;

#-----------------------------------------------------------------------------
#-- rocznik
#-----------------------------------------------------------------------------

DROP TABLE IF EXISTS `rocznik`;


CREATE TABLE `rocznik`
(
	`rocznik_id` INTEGER  NOT NULL AUTO_INCREMENT,
	`rok` INTEGER  NOT NULL,
	`liczbaartykulow` INTEGER,
	`liczbastron` INTEGER,
	`slug` VARCHAR(128)  NOT NULL,
	PRIMARY KEY (`rocznik_id`),
	UNIQUE KEY `rocznik_U_1` (`slug`(128))
)Type=InnoDB;

#-----------------------------------------------------------------------------
#-- rubryka
#-----------------------------------------------------------------------------

DROP TABLE IF EXISTS `rubryka`;


CREATE TABLE `rubryka`
(
	`rubryka_id` INTEGER  NOT NULL AUTO_INCREMENT,
	`rubryka` VARCHAR(255)  NOT NULL,
	`liczbaartykulow` INTEGER,
	`liczbastron` INTEGER,
	`slug` VARCHAR(128)  NOT NULL,
	PRIMARY KEY (`rubryka_id`),
	UNIQUE KEY `rubryka_U_1` (`slug`(128))
)Type=InnoDB;

#-----------------------------------------------------------------------------
#-- podrubryka
#-----------------------------------------------------------------------------

DROP TABLE IF EXISTS `podrubryka`;


CREATE TABLE `podrubryka`
(
	`podrubryka_id` INTEGER  NOT NULL AUTO_INCREMENT,
	`podrubryka` VARCHAR(255)  NOT NULL,
	`liczbaartykulow` INTEGER,
	`liczbastron` INTEGER,
	`slug` VARCHAR(128)  NOT NULL,
	PRIMARY KEY (`podrubryka_id`),
	UNIQUE KEY `podrubryka_U_1` (`slug`(128))
)Type=InnoDB;

#-----------------------------------------------------------------------------
#-- artykul_has_autor
#-----------------------------------------------------------------------------

DROP TABLE IF EXISTS `artykul_has_autor`;


CREATE TABLE `artykul_has_autor`
(
	`artykul_id` INTEGER  NOT NULL,
	`autor_id` INTEGER  NOT NULL,
	PRIMARY KEY (`artykul_id`,`autor_id`),
	CONSTRAINT `fk_artykul_has_autor_artykul1`
		FOREIGN KEY (`artykul_id`)
		REFERENCES `artykul` (`artykul_id`)
		ON UPDATE CASCADE
		ON DELETE CASCADE,
	INDEX `FI_artykul_has_autor_autor1` (`autor_id`),
	CONSTRAINT `fk_artykul_has_autor_autor1`
		FOREIGN KEY (`autor_id`)
		REFERENCES `autor` (`autor_id`)
		ON UPDATE CASCADE
		ON DELETE CASCADE
)Type=InnoDB;

# This restores the fkey checks, after having unset them earlier
SET FOREIGN_KEY_CHECKS = 1;
