<?php


/**
 * This class adds structure of 'wydzial' table to 'angaze' DatabaseMap object.
 *
 *
 *
 * These statically-built map classes are used by Propel to do runtime db structure discovery.
 * For example, the createSelectSql() method checks the type of a given column used in an
 * ORDER BY clause to know whether it needs to apply SQL to make the ORDER BY case-insensitive
 * (i.e. if it's a text column type).
 *
 * @package    angaze.map
 */
class WydzialMapBuilder implements MapBuilder {

	/**
	 * The (dot-path) name of this class
	 */
	const CLASS_NAME = 'angaze.map.WydzialMapBuilder';

	/**
	 * The database map.
	 */
	private $dbMap;

	/**
	 * Tells us if this DatabaseMapBuilder is built so that we
	 * don't have to re-build it every time.
	 *
	 * @return     boolean true if this DatabaseMapBuilder is built, false otherwise.
	 */
	public function isBuilt()
	{
		return ($this->dbMap !== null);
	}

	/**
	 * Gets the databasemap this map builder built.
	 *
	 * @return     the databasemap
	 */
	public function getDatabaseMap()
	{
		return $this->dbMap;
	}

	/**
	 * The doBuild() method builds the DatabaseMap
	 *
	 * @return     void
	 * @throws     PropelException
	 */
	public function doBuild()
	{
		$this->dbMap = Propel::getDatabaseMap(WydzialPeer::DATABASE_NAME);

		$tMap = $this->dbMap->addTable(WydzialPeer::TABLE_NAME);
		$tMap->setPhpName('Wydzial');
		$tMap->setClassname('Wydzial');

		$tMap->setUseIdGenerator(true);

		$tMap->addPrimaryKey('WYDZIAL_ID', 'WydzialId', 'INTEGER', true, null);

		$tMap->addColumn('NAZWA', 'Nazwa', 'VARCHAR', false, 45);

		$tMap->addColumn('SKROT', 'Skrot', 'VARCHAR', false, 20);

		$tMap->addColumn('SLUG', 'Slug', 'VARCHAR', true, 128);

	} // doBuild()

} // WydzialMapBuilder
