<?php

require 'angaze/om/BaseKierunekPeer.php';


/**
 * Skeleton subclass for performing query and update operations on the 'kierunek' table.
 *
 * 
 *
 * You should add additional methods to this class to meet the
 * application requirements.  This class will only be generated as
 * long as it does not already exist in the output directory.
 *
 * @package    angaze
 */
class KierunekPeer extends BaseKierunekPeer {

    public static function insertIfNotExists($dane)
    {
        $c = new Criteria();
        $c->add(self::SLUG, $dane['slug']);
        $tmp = self::doSelectOne($c);
        if (!$tmp) {
            $tmp = new Kierunek();
            $tmp->fromArray($dane, BasePeer::TYPE_FIELDNAME);
            $tmp->save();
        }
        return $tmp;
    }

    static public function doSelect($criteria = null, $con = null)
    {
        if (is_null($criteria)) {
            $criteria = new Criteria();
        } else {
            $criteria = clone $criteria;
        }
        $criteria->addAscendingOrderByColumn(self::NAZWA);                    
        $criteria->addAscendingOrderByColumn(self::RODZAJSTUDIOW_ID);                            
        return parent::doSelect($criteria, $con);
    }        

    static public function retrieveBySlug($slug)
    {
        $c = new Criteria();
        $c->add(self::SLUG, $slug);
        return parent::doSelectOne($c);
    }

} // KierunekPeer
