<?php

error_reporting(E_ALL);
ini_set('display_errors', 1);

set_include_path(
    '../aplikacja/scripts' . PATH_SEPARATOR .
    '../aplikacja/scripts/include' . PATH_SEPARATOR .
    '../lib' . PATH_SEPARATOR .
    get_include_path()
);

require_once 'Doctrine/lib/Doctrine.php';
spl_autoload_register(array('Doctrine', 'autoload'));
$conn = Doctrine_Manager::connection('mysql://admin:password@localhost/filmy');
Doctrine::loadModels('./../lib', Doctrine::MODEL_LOADING_CONSERVATIVE);
$conn->setCollate('utf8_polish_ci');
$conn->setCharset('utf8');

require_once '../lib/film.php';
require_once '../lib/aktor.php';

require_once 'slugs.inc.php';
require_once 'pomocnicze.inc.php';

$plk = file('filmy.txt');
shuffle($plk);
foreach ($plk as $linia) {
    $tmp = parsuj_film(trim($linia));
    
    $q = Doctrine_Query::create()
        ->from('Film f')
        ->where('f.tytul = ?', $tmp['tytul']);
    $film = $q->fetchOne();
    if (!$film) {
        $film = new Film();
        $film['tytul'] = $tmp['tytul'];
        $film['slug'] = string2slug($tmp['tytul']);
        $film->save();
    }
    foreach ($tmp['aktorzy'] as $a) {
        $q = Doctrine_Query::create()
            ->from('Aktor a')
            ->where('a.imie = ?', $a['imie'])
            ->andWhere('a.nazwisko = ?', $a['nazwisko']);
        $aktor = $q->fetchOne();
        if (!$aktor) {
            $aktor = new Aktor();
            $aktor['imie'] = $a['imie'];
            $aktor['nazwisko'] = $a['nazwisko'];
            $aktor['slug'] = string2slug($a['imie'] . ' ' . $a['nazwisko']);
            $aktor->save();
        }
        
        $fa = new FilmAktor();
        $fa['aktor'] = $aktor;
        $fa['film']  = $film;

        try {
            $fa->save();
        } catch (Exception $e) {
            echo 'ERROR: ' . $e->getMessage() . "<br />\n";
        }

    }
}