<?php

require_once 'XML/Serializer.php';

$serializer = new XML_Serializer();

$options = array(
    'addDecl'        => true,
    'indent'         => '    ',
    'rootName'       => 'mecze',
    'encoding'       => 'utf-8',
    'defaultTagName' => 'mecz',
    'scalarAsAttributes' => array(
        'mecz' => array('rok', 'miesiac', 'dzien')
    )
);

$serializer->setOptions($options);


$dane = array();

$plik = file('mecze.txt');
foreach ($plik as $linia) {
    $e = explode('|', trim($linia)); 
    $tmp = array(
        'kolejka'           => $e[0],
        'gospodarz'         => $e[1],
        'przeciwnik'        => $e[2],
        'wynik' => array(
            'koncowy' => array(
                'gol1' => $e[3],
                'gol2' => $e[4],            
            ),
            'do-przerwy' => array(
                'gol3' => $e[5],
                'gol4' => $e[6],                    
            )
        ),
        'rok'               => $e[7],
        'miesiac'           => $e[8],
        'dzien'             => $e[9],
        'godz'              => $e[10],        
        'min'               => $e[11],  
	'sedzia-glowny' => array(
            'imie'      => $e[12],                        
            'nazwisko'  => $e[13],                                
            'miasto'    => $e[14],                        	
	),              
	'sedzia-liniowy-1' => array(
            'imie'     => $e[15],                        
            'nazwisko' => $e[16],                                
        ),
	'sedzia-liniowy-2' => array(
            'imie'     => $e[15],                        
            'nazwisko' => $e[16],                                
        )
    );
    array_push($dane, $tmp);
}


$serializer->serialize($dane);

$wynik = $serializer->getSerializedData();

file_put_contents('mecze.xml', $wynik);
