<?php


/**
 * This class adds structure of 'aparat' table to 'aparatyfoto' DatabaseMap object.
 *
 *
 *
 * These statically-built map classes are used by Propel to do runtime db structure discovery.
 * For example, the createSelectSql() method checks the type of a given column used in an
 * ORDER BY clause to know whether it needs to apply SQL to make the ORDER BY case-insensitive
 * (i.e. if it's a text column type).
 *
 * @package    aparatyfoto.map
 */
class AparatMapBuilder implements MapBuilder {

	/**
	 * The (dot-path) name of this class
	 */
	const CLASS_NAME = 'aparatyfoto.map.AparatMapBuilder';

	/**
	 * The database map.
	 */
	private $dbMap;

	/**
	 * Tells us if this DatabaseMapBuilder is built so that we
	 * don't have to re-build it every time.
	 *
	 * @return     boolean true if this DatabaseMapBuilder is built, false otherwise.
	 */
	public function isBuilt()
	{
		return ($this->dbMap !== null);
	}

	/**
	 * Gets the databasemap this map builder built.
	 *
	 * @return     the databasemap
	 */
	public function getDatabaseMap()
	{
		return $this->dbMap;
	}

	/**
	 * The doBuild() method builds the DatabaseMap
	 *
	 * @return     void
	 * @throws     PropelException
	 */
	public function doBuild()
	{
		$this->dbMap = Propel::getDatabaseMap(AparatPeer::DATABASE_NAME);

		$tMap = $this->dbMap->addTable(AparatPeer::TABLE_NAME);
		$tMap->setPhpName('Aparat');
		$tMap->setClassname('Aparat');

		$tMap->setUseIdGenerator(true);

		$tMap->addPrimaryKey('APARAT_ID', 'AparatId', 'INTEGER', true, null);

		$tMap->addColumn('MODEL', 'Model', 'VARCHAR', false, 45);

		$tMap->addColumn('TYP', 'Typ', 'VARCHAR', false, 45);

		$tMap->addColumn('MEGAPIXEL', 'Megapixel', 'VARCHAR', false, 45);

		$tMap->addColumn('LCD', 'Lcd', 'VARCHAR', false, 45);

		$tMap->addColumn('WYMIAR_MATRYCY', 'WymiarMatrycy', 'VARCHAR', false, 45);

		$tMap->addColumn('PAMIEC', 'Pamiec', 'VARCHAR', false, 45);

		$tMap->addColumn('MOCOWANIE_OBIEKTYWU', 'MocowanieObiektywu', 'VARCHAR', false, 45);

		$tMap->addColumn('MNOZNIK_OGNISKOWEJ', 'MnoznikOgniskowej', 'VARCHAR', false, 45);

		$tMap->addColumn('STABILIZACJA_OBRAZU', 'StabilizacjaObrazu', 'VARCHAR', false, 45);

		$tMap->addColumn('MIGAWKA', 'Migawka', 'VARCHAR', false, 45);

		$tMap->addColumn('CZULOSC', 'Czulosc', 'VARCHAR', false, 45);

		$tMap->addColumn('AUTOBRAKETING', 'Autobraketing', 'VARCHAR', false, 45);

		$tMap->addColumn('PODGLAD_GLEBI', 'PodgladGlebi', 'VARCHAR', false, 45);

		$tMap->addColumn('BALANS_BIELI', 'BalansBieli', 'VARCHAR', false, 45);

		$tMap->addColumn('ZDJECIA_SERYJNE', 'ZdjeciaSeryjne', 'VARCHAR', false, 45);

		$tMap->addColumn('POLE_WIDZENIA', 'PoleWidzenia', 'VARCHAR', false, 45);

		$tMap->addColumn('KORPUS', 'Korpus', 'VARCHAR', false, 45);

		$tMap->addColumn('BATERIE', 'Baterie', 'VARCHAR', false, 45);

		$tMap->addColumn('CENA', 'Cena', 'VARCHAR', false, 45);

		$tMap->addColumn('SLUG', 'Slug', 'VARCHAR', false, 45);

		$tMap->addForeignKey('PRODUCENT_ID', 'ProducentId', 'INTEGER', 'producent', 'PRODUCENT_ID', false, null);

		$tMap->addForeignKey('MATRYCA_ID', 'MatrycaId', 'INTEGER', 'matryca', 'MATRYCA_ID', false, null);

	} // doBuild()

} // AparatMapBuilder
