<?php


/**
 * This class adds structure of 'rocznik' table to 'artykulymi' DatabaseMap object.
 *
 *
 *
 * These statically-built map classes are used by Propel to do runtime db structure discovery.
 * For example, the createSelectSql() method checks the type of a given column used in an
 * ORDER BY clause to know whether it needs to apply SQL to make the ORDER BY case-insensitive
 * (i.e. if it's a text column type).
 *
 * @package    artykulymi.map
 */
class RocznikMapBuilder implements MapBuilder {

	/**
	 * The (dot-path) name of this class
	 */
	const CLASS_NAME = 'artykulymi.map.RocznikMapBuilder';

	/**
	 * The database map.
	 */
	private $dbMap;

	/**
	 * Tells us if this DatabaseMapBuilder is built so that we
	 * don't have to re-build it every time.
	 *
	 * @return     boolean true if this DatabaseMapBuilder is built, false otherwise.
	 */
	public function isBuilt()
	{
		return ($this->dbMap !== null);
	}

	/**
	 * Gets the databasemap this map builder built.
	 *
	 * @return     the databasemap
	 */
	public function getDatabaseMap()
	{
		return $this->dbMap;
	}

	/**
	 * The doBuild() method builds the DatabaseMap
	 *
	 * @return     void
	 * @throws     PropelException
	 */
	public function doBuild()
	{
		$this->dbMap = Propel::getDatabaseMap(RocznikPeer::DATABASE_NAME);

		$tMap = $this->dbMap->addTable(RocznikPeer::TABLE_NAME);
		$tMap->setPhpName('Rocznik');
		$tMap->setClassname('Rocznik');

		$tMap->setUseIdGenerator(true);

		$tMap->addPrimaryKey('ROCZNIK_ID', 'RocznikId', 'INTEGER', true, null);

		$tMap->addColumn('ROK', 'Rok', 'INTEGER', true, null);

		$tMap->addColumn('LICZBAARTYKULOW', 'Liczbaartykulow', 'INTEGER', false, null);

		$tMap->addColumn('LICZBASTRON', 'Liczbastron', 'INTEGER', false, null);

		$tMap->addColumn('SLUG', 'Slug', 'VARCHAR', true, 128);

	} // doBuild()

} // RocznikMapBuilder
